/*
 * Decompiled with CFR 0.152.
 */
package astro;

public class UdMath {
    static double fmod(double d, double d2) {
        return d - Math.ceil(d / d2) * d2;
    }

    static double udsin(double d) {
        return Math.sin(d * Math.PI / 180.0);
    }

    static double udcos(double d) {
        return Math.cos(d * Math.PI / 180.0);
    }

    static double udtan(double d) {
        return Math.tan(d * Math.PI / 180.0);
    }

    static double degmal(double d) {
        double d2 = 360.0 * (d / 360.0 - Math.floor(d / 360.0));
        if (d2 < 0.0) {
            d2 += 360.0;
        }
        if (d2 >= 360.0) {
            d2 -= 360.0;
        }
        return d2;
    }

    static double radmal(double d) {
        double d2 = Math.PI * 2 * (d / (Math.PI * 2) - Math.floor(d / (Math.PI * 2)));
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        if (d2 >= Math.PI * 2) {
            d2 -= Math.PI * 2;
        }
        return d2;
    }

    static double deg2rad(double d) {
        return d * Math.PI / 180.0;
    }

    static double rad2deg(double d) {
        return d * 180.0 / Math.PI;
    }

    static double arccosh(double d) {
        return Math.log(d + Math.sqrt(d * d - 1.0));
    }

    static double sinh(double d) {
        return (Math.exp(d) - Math.exp(-d)) / 2.0;
    }

    static double cosh(double d) {
        return (Math.exp(d) + Math.exp(-d)) / 2.0;
    }
}

