/*
 * Decompiled with CFR 0.152.
 */
package astro;

import astro.ATime;
import astro.Matrix;
import astro.PlanetElm;
import astro.UdMath;
import astro.Xyz;

public class PlanetOrbit {
    private int planetNo;
    private double jd;
    private int nDivision;
    private Xyz[] orbit;

    private void doGetPlanetOrbit(PlanetElm planetElm) {
        double d = -2.0 * planetElm.axis * planetElm.e;
        double d2 = Math.sqrt(1.0 - planetElm.e * planetElm.e);
        int n = 0;
        int n2 = this.nDivision / 2;
        int n3 = this.nDivision / 2;
        int n4 = this.nDivision;
        double d3 = 0.0;
        int n5 = 0;
        while (n5 <= this.nDivision / 4) {
            double d4 = planetElm.axis * (UdMath.udcos(d3) - planetElm.e);
            double d5 = planetElm.axis * d2 * UdMath.udsin(d3);
            this.orbit[n++] = new Xyz(d4, d5, 0.0);
            this.orbit[n2--] = new Xyz(d - d4, d5, 0.0);
            this.orbit[n3++] = new Xyz(d - d4, -d5, 0.0);
            this.orbit[n4--] = new Xyz(d4, -d5, 0.0);
            ++n5;
            d3 += 360.0 / (double)this.nDivision;
        }
    }

    public PlanetOrbit(int n, ATime aTime, int n2) {
        this.planetNo = n;
        this.jd = aTime.getJd();
        this.nDivision = n2;
        PlanetElm planetElm = new PlanetElm(n, aTime);
        this.orbit = new Xyz[n2 + 1];
        this.doGetPlanetOrbit(planetElm);
        Matrix matrix = Matrix.VectorConstant(planetElm.peri * Math.PI / 180.0, planetElm.node * Math.PI / 180.0, planetElm.incl * Math.PI / 180.0, aTime);
        Matrix matrix2 = Matrix.PrecMatrix(aTime.getJd(), 2451512.5);
        int n3 = 0;
        while (n3 <= n2) {
            this.orbit[n3] = this.orbit[n3].Rotate(matrix).Rotate(matrix2);
            ++n3;
        }
    }

    public double getEpoch() {
        return this.jd;
    }

    public int getDivision() {
        return this.nDivision;
    }

    public Xyz getAt(int n) {
        return this.orbit[n];
    }
}

