/*
 * Decompiled with CFR 0.152.
 */
package astro;

import astro.ATime;
import astro.PlanetElmP1;
import astro.PlanetElmP2;
import astro.UdMath;
import astro.Xyz;

class PlanetElm {
    double L;
    double node;
    double peri;
    double axis;
    double e;
    double incl;
    static final PlanetElmP1 MercuryE = new PlanetElmP1(182.27175, 149474.07244, 0.00201944, 0.0, 75.89717, 1.553469, 3.08639E-4, 0.0, 47.144736, 1.18476, 2.23194E-4, 0.0, 7.003014, 0.00173833, -1.55555E-5, 0.0, 0.20561494, 2.03E-5, -4.0E-8, 0.0, 0.3870984);
    static final PlanetElmP1 VenusE = new PlanetElmP1(344.36936, 58519.2126, 9.8055E-4, 0.0, 130.14057, 1.3723, -0.0016472, 0.0, 75.7881, 0.91403, 4.189E-4, 0.0, 3.3936, 0.0012522, -4.333E-6, 0.0, 0.00681636, -5.384E-5, 1.26E-7, 0.0, 0.72333015);
    static final PlanetElmP1 MarsE = new PlanetElmP1(294.26478, 19141.69625, 3.15028E-4, 0.0, 334.21833, 1.840394, 3.35917E-4, 0.0, 48.7867, 0.776944, -6.02778E-4, 0.0, 1.8503, -6.49028E-4, 2.625E-5, 0.0, 0.0933088, 9.5284E-5, -1.22E-7, 0.0, 1.5236781);
    static final PlanetElmP1 JupiterE = new PlanetElmP1(238.132386, 3036.301986, 3.34683E-4, -1.64889E-6, 12.720972, 1.6099617, 0.00105627, -3.4333E-6, 99.443414, 1.01053, 3.52222E-4, -8.51111E-6, 1.308736, -0.00569611, 3.88889E-6, 0.0, 0.0483348, 1.6418E-4, -4.676E-7, -1.7E-9, 5.202805);
    static final PlanetElmP1 SaturnE = new PlanetElmP1(266.597875, 1223.50988, 3.24542E-4, -5.83333E-7, 91.09821, 1.958416, 8.26361E-4, 4.61111E-6, 112.790414, 0.873195, -1.52181E-4, -5.30555E-6, 2.49252, -0.00391889, -1.54889E-5, 4.44444E-8, 0.05589231, -3.455E-4, -7.28E-7, 7.4E-10, 9.55474);
    static final PlanetElmP2 UranusE = new PlanetElmP2(314.055005, 0.01176903644, 3.043E-4, 173.005159, 1.4863784, 2.145E-4, 74.005947, 0.5211258, 0.0013399, 19.2184461, -3.7E-8, 0.0, 0.0462959, -2.7337E-5, 7.9E-8, 0.773196, 7.744E-4, 3.75E-5);
    static final PlanetElmP2 NeptuneE = new PlanetElmP2(304.348665, 0.00602007691, 3.093E-4, 48.123691, 1.4262678, 3.792E-4, 131.784057, 1.1022035, 2.6E-4, 30.1103869, -1.66E-7, 0.0, 0.00898809, 6.408E-6, -1.0E-9, 1.769952, -0.0093082, -7.1E-6);
    static final PlanetElmP2 PlutoE = new PlanetElmP2(238.467028, 0.00401595755, -0.0090561, 224.14163, 1.3900789, 3.019E-4, 110.318223, 1.3506963, 4.014E-4, 39.5403429, 0.00313105, -3.792E-5, 0.24900535, 3.885E-5, -5.62E-7, 17.145104, -0.0054981, -3.84E-5);
    private static int[] perturbJup1;
    private static int[] perturbJup2;
    private static int[] perturbJup3;
    private static int[] perturbSat1;
    private static int[] perturbSat2;
    private static int[] perturbSat3;
    private static int[] perturbSat4;

    double perturbationElement(double d, double d2, int[] nArray) {
        int n = (int)(d / 30.0);
        int n2 = n + 1;
        int n3 = (int)(d2 / 30.0);
        int n4 = n3 + 1;
        if (n >= 12 && n3 >= 12) {
            return nArray[n3 * 13 + n];
        }
        if (n >= 12) {
            double d3 = nArray[n3 * 13 + n];
            double d4 = nArray[n4 * 13 + n];
            double d5 = d3 + (d4 - d3) * (d2 / 30.0 - (double)n3);
            return d5;
        }
        if (n3 >= 12) {
            double d6 = nArray[n3 * 13 + n];
            double d7 = nArray[n3 * 13 + n2];
            double d8 = d6 + (d7 - d6) * (d / 30.0 - (double)n);
            return d8;
        }
        double d9 = nArray[n3 * 13 + n];
        double d10 = nArray[n3 * 13 + n2];
        double d11 = nArray[n4 * 13 + n];
        double d12 = nArray[n4 * 13 + n2];
        double d13 = d9 + (d11 - d9) * (d2 / 30.0 - (double)n3);
        double d14 = d10 + (d12 - d10) * (d2 / 30.0 - (double)n3);
        double d15 = d13 + (d14 - d13) * (d / 30.0 - (double)n);
        return d15;
    }

    private void perturbationJupiter(double d) {
        int n = (int)((d - 1721423.5) / 365.244 + 1.0);
        double d2 = (double)n / 1000.0;
        double d3 = (0.42 - 0.075 * d2 + 0.015 * d2 * d2 - 0.003 * d2 * d2 * d2) * UdMath.udsin((d2 - 0.62) * 360.0 / 0.925);
        double d4 = 0.02 * UdMath.udsin((d2 + 0.1) * 360.0 / 0.925);
        double d5 = 0.03 * UdMath.udsin((d2 + 0.36) * 360.0 / 0.925);
        double d6 = UdMath.degmal(86.1 + 0.033459 * (d - 1721057.0));
        double d7 = UdMath.degmal(89.1 + 0.04963 * (d - 1721057.0));
        double d8 = this.perturbationElement(d6, d7, perturbJup1) / 1000.0;
        double d9 = this.perturbationElement(d6, d7, perturbJup2) / 1000.0;
        double d10 = this.perturbationElement(d6, d7, perturbJup3) / 1000.0;
        double d11 = 2.58 + 0.1 * d2;
        if (d11 > 3.5) {
            d11 = 3.5;
        }
        if (d11 < 1.5) {
            d11 = 1.5;
        }
        this.L += d3 + d8;
        this.peri += (d4 + d9) / UdMath.udsin(d11);
        this.e = UdMath.udsin(d11 + d5 + d10);
    }

    void perturbationSaturn(double d) {
        int n = (int)((d - 1721423.5) / 365.244 + 1.0);
        double d2 = (double)n / 1000.0;
        double d3 = 0.88 - 0.0633 * d2 + 0.03 * d2 * d2 - 6.0E-4 * d2 * d2 * d2;
        double d4 = -0.5 + d3 * UdMath.udsin((d2 - 0.145) * 360.0 / 0.95);
        double d5 = -0.5 + (0.1 - 0.005 * d2) * UdMath.udsin((d2 - 0.54) * 360.0 / 0.95);
        double d6 = -0.5 + (0.1 - 0.005 * d2) * UdMath.udsin((d2 - 0.32) * 360.0 / 0.95);
        double d7 = -0.05 + (0.004 - 5.0E-4 * d2) * UdMath.udsin((d2 - 0.35) * 360.0 / 0.95);
        double d8 = UdMath.degmal(86.1 + 0.033459 * (d - 1721057.0));
        double d9 = UdMath.degmal(89.1 + 0.04963 * (d - 1721057.0));
        double d10 = this.perturbationElement(d8, d9, perturbSat1) / 100.0;
        double d11 = this.perturbationElement(d8, d9, perturbSat2) / 100.0;
        double d12 = this.perturbationElement(d8, d9, perturbSat3) / 100.0;
        double d13 = this.perturbationElement(d8, d9, perturbSat4) / 1000.0;
        double d14 = 3.56 - 0.175 * d2 - 0.005 * d2 * d2;
        if (d14 < 2.0) {
            d14 = 2.0;
        }
        this.L += d4 + d10;
        this.peri += (d5 + d11) / UdMath.udsin(d14);
        this.e = UdMath.udsin(d14 + d6 + d12);
        this.axis += d7 + d13;
    }

    private void getPlanetElm1(int n, double d) {
        PlanetElmP1 planetElmP1;
        double d2 = (d - 2415021.0) / 36525.0;
        double d3 = d2 * d2;
        switch (n) {
            case 1: {
                planetElmP1 = MercuryE;
                break;
            }
            case 2: {
                planetElmP1 = VenusE;
                break;
            }
            case 4: {
                planetElmP1 = MarsE;
                break;
            }
            case 5: {
                planetElmP1 = JupiterE;
                break;
            }
            case 6: {
                planetElmP1 = SaturnE;
                break;
            }
            default: {
                throw new ArithmeticException();
            }
        }
        this.L = UdMath.degmal(planetElmP1.L + planetElmP1.L1 * d2 + planetElmP1.L2 * d3 + planetElmP1.L3 * d2 * d3);
        this.node = UdMath.degmal(planetElmP1.node + planetElmP1.n1 * d2 + planetElmP1.n2 * d3 + planetElmP1.n3 * d2 * d3);
        this.peri = UdMath.degmal(planetElmP1.peri + planetElmP1.p1 * d2 + planetElmP1.p2 * d3 + planetElmP1.p3 * d2 * d3 - this.node);
        this.axis = planetElmP1.axis;
        this.e = UdMath.degmal(planetElmP1.e + planetElmP1.e1 * d2 + planetElmP1.e2 * d3 + planetElmP1.e3 * d2 * d3);
        this.incl = UdMath.degmal(planetElmP1.incl + planetElmP1.i1 * d2 + planetElmP1.i2 * d3 + planetElmP1.i3 * d2 * d3);
        switch (n) {
            case 5: {
                this.perturbationJupiter(d);
                return;
            }
            case 6: {
                this.perturbationSaturn(d);
                return;
            }
        }
    }

    private void getPlanetElm2(int n, double d) {
        double d2 = (d - 2451545.0) / 36525.0;
        double d3 = d2 * d2;
        double d4 = d2 * 36525.0;
        PlanetElmP2 planetElmP2 = null;
        switch (n) {
            case 7: {
                planetElmP2 = UranusE;
                break;
            }
            case 8: {
                planetElmP2 = NeptuneE;
                break;
            }
            case 9: {
                planetElmP2 = PlutoE;
                break;
            }
            default: {
                throw new ArithmeticException();
            }
        }
        this.L = UdMath.degmal(planetElmP2.L + planetElmP2.L1 * d4 + planetElmP2.L2 * d3);
        this.node = UdMath.degmal(planetElmP2.node + planetElmP2.n1 * d2 + planetElmP2.n2 * d3);
        this.peri = UdMath.degmal(planetElmP2.peri + planetElmP2.p1 * d2 + planetElmP2.p2 * d3 - this.node);
        this.axis = UdMath.degmal(planetElmP2.axis + planetElmP2.a1 * d2 + planetElmP2.a2 * d3);
        this.e = UdMath.degmal(planetElmP2.e + planetElmP2.e1 * d2 + planetElmP2.e2 * d3);
        this.incl = UdMath.degmal(planetElmP2.incl + planetElmP2.i1 * d2 + planetElmP2.i2 * d3);
    }

    private void getPlanetElmEarth(double d) {
        double d2 = (d - 2415021.0) / 36525.0;
        double d3 = d2 * d2;
        this.L = 180.0 + UdMath.degmal(280.6824 + 36000.769325 * d2 + 7.22222E-4 * d3);
        this.peri = 180.0 + UdMath.degmal(281.2206 + 1.717697 * d2 + 4.83333E-4 * d3 + 2.77777E-6 * d2 * d3);
        this.node = 0.0;
        this.incl = 0.0;
        this.e = 0.0167498 - 4.258E-5 * d2 - 1.37E-7 * d3;
        this.axis = 1.00000129;
    }

    public PlanetElm(int n, ATime aTime) {
        switch (n) {
            case 3: {
                this.getPlanetElmEarth(aTime.getJd());
                return;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                this.getPlanetElm1(n, aTime.getJd());
                return;
            }
            case 7: 
            case 8: 
            case 9: {
                this.getPlanetElm2(n, aTime.getJd());
                return;
            }
        }
        throw new ArithmeticException();
    }

    public Xyz getPos() {
        double d;
        double d2;
        double d3 = this.e * 180.0 / Math.PI;
        double d4 = d2 = this.L - (this.peri + this.node);
        while (Math.abs((d4 = d2 + d3 * UdMath.udsin(d = d4)) - d) > 5.729577951308233E-4) {
        }
        double d5 = this.axis * (UdMath.udcos(d4) - this.e);
        double d6 = this.axis * Math.sqrt(1.0 - this.e * this.e) * UdMath.udsin(d4);
        double d7 = UdMath.udsin(this.peri);
        double d8 = UdMath.udcos(this.peri);
        double d9 = UdMath.udsin(this.node);
        double d10 = UdMath.udcos(this.node);
        double d11 = UdMath.udsin(this.incl);
        double d12 = UdMath.udcos(this.incl);
        double d13 = d5 * (d10 * d8 - d9 * d12 * d7) - d6 * (d10 * d7 + d9 * d12 * d8);
        double d14 = d5 * (d9 * d8 + d10 * d12 * d7) - d6 * (d9 * d7 - d10 * d12 * d8);
        double d15 = d5 * (d11 * d7) + d6 * (d11 * d8);
        return new Xyz(d13, d14, d15);
    }

    static {
        int[] nArray = new int[169];
        nArray[0] = -20;
        nArray[1] = -27;
        nArray[2] = -44;
        nArray[3] = -36;
        nArray[4] = -20;
        nArray[5] = 10;
        nArray[6] = 21;
        nArray[7] = 27;
        nArray[8] = 33;
        nArray[9] = 25;
        nArray[10] = 18;
        nArray[11] = 8;
        nArray[12] = -20;
        nArray[13] = -14;
        nArray[14] = -25;
        nArray[15] = -57;
        nArray[16] = -75;
        nArray[17] = -70;
        nArray[18] = -55;
        nArray[19] = -25;
        nArray[20] = -15;
        nArray[21] = -2;
        nArray[22] = 8;
        nArray[23] = 1;
        nArray[24] = -4;
        nArray[25] = -15;
        nArray[26] = 5;
        nArray[27] = -5;
        nArray[28] = -21;
        nArray[29] = -55;
        nArray[30] = -67;
        nArray[31] = -72;
        nArray[32] = -55;
        nArray[33] = -28;
        nArray[34] = -13;
        nArray[36] = 7;
        nArray[37] = 10;
        nArray[38] = 5;
        nArray[39] = 24;
        nArray[40] = 21;
        nArray[41] = 9;
        nArray[42] = -11;
        nArray[43] = -37;
        nArray[44] = -57;
        nArray[45] = -55;
        nArray[46] = -37;
        nArray[47] = -15;
        nArray[48] = 3;
        nArray[49] = 13;
        nArray[50] = 18;
        nArray[51] = 23;
        nArray[52] = 27;
        nArray[53] = 29;
        nArray[54] = 27;
        nArray[55] = 15;
        nArray[56] = 4;
        nArray[57] = -25;
        nArray[58] = -45;
        nArray[59] = -38;
        nArray[60] = -22;
        nArray[61] = -5;
        nArray[62] = 10;
        nArray[63] = 25;
        nArray[64] = 30;
        nArray[65] = 15;
        nArray[66] = 27;
        nArray[67] = 39;
        nArray[68] = 33;
        nArray[69] = 25;
        nArray[70] = -5;
        nArray[71] = -27;
        nArray[72] = -34;
        nArray[73] = -30;
        nArray[74] = -19;
        nArray[75] = -6;
        nArray[76] = 20;
        nArray[77] = 21;
        nArray[78] = 7;
        nArray[79] = 15;
        nArray[80] = 25;
        nArray[81] = 31;
        nArray[82] = 24;
        nArray[83] = 8;
        nArray[84] = -11;
        nArray[85] = -26;
        nArray[86] = -32;
        nArray[87] = -27;
        nArray[88] = -19;
        nArray[89] = -6;
        nArray[90] = 16;
        nArray[91] = -3;
        nArray[92] = 3;
        nArray[93] = 15;
        nArray[94] = 23;
        nArray[95] = 22;
        nArray[96] = 15;
        nArray[98] = -15;
        nArray[99] = -26;
        nArray[100] = -29;
        nArray[101] = -25;
        nArray[102] = -20;
        nArray[103] = -4;
        nArray[104] = -15;
        nArray[105] = -5;
        nArray[106] = 3;
        nArray[107] = 17;
        nArray[108] = 22;
        nArray[109] = 20;
        nArray[110] = 11;
        nArray[111] = 5;
        nArray[112] = -11;
        nArray[113] = -26;
        nArray[114] = -27;
        nArray[115] = -25;
        nArray[116] = -16;
        nArray[117] = -17;
        nArray[118] = -4;
        nArray[119] = 10;
        nArray[120] = 20;
        nArray[121] = 25;
        nArray[122] = 31;
        nArray[123] = 25;
        nArray[124] = 24;
        nArray[125] = 15;
        nArray[126] = -6;
        nArray[127] = -15;
        nArray[128] = -18;
        nArray[129] = -13;
        nArray[131] = 2;
        nArray[132] = 13;
        nArray[133] = 28;
        nArray[134] = 39;
        nArray[135] = 49;
        nArray[136] = 48;
        nArray[137] = 38;
        nArray[138] = 33;
        nArray[139] = 27;
        nArray[140] = 13;
        nArray[141] = -1;
        nArray[142] = -2;
        nArray[143] = -1;
        nArray[145] = 6;
        nArray[146] = 23;
        nArray[147] = 39;
        nArray[148] = 49;
        nArray[149] = 63;
        nArray[150] = 53;
        nArray[151] = 48;
        nArray[152] = 41;
        nArray[153] = 35;
        nArray[154] = 17;
        nArray[155] = 4;
        nArray[156] = -26;
        nArray[157] = -30;
        nArray[158] = -30;
        nArray[159] = -25;
        nArray[160] = -9;
        nArray[161] = 17;
        nArray[162] = 31;
        nArray[163] = 34;
        nArray[164] = 34;
        nArray[165] = 25;
        nArray[166] = 22;
        nArray[167] = 13;
        nArray[168] = 6;
        perturbJup1 = nArray;
        int[] nArray2 = new int[169];
        nArray2[0] = 4;
        nArray2[1] = 15;
        nArray2[2] = 30;
        nArray2[3] = 40;
        nArray2[4] = 40;
        nArray2[5] = 25;
        nArray2[6] = 6;
        nArray2[7] = 8;
        nArray2[8] = -27;
        nArray2[9] = -43;
        nArray2[10] = -43;
        nArray2[11] = -28;
        nArray2[12] = -5;
        nArray2[13] = -24;
        nArray2[14] = -9;
        nArray2[15] = 7;
        nArray2[16] = 10;
        nArray2[17] = 27;
        nArray2[18] = 30;
        nArray2[19] = 31;
        nArray2[20] = 17;
        nArray2[21] = -4;
        nArray2[22] = -29;
        nArray2[23] = -43;
        nArray2[24] = -40;
        nArray2[25] = -27;
        nArray2[26] = -31;
        nArray2[27] = -24;
        nArray2[28] = -25;
        nArray2[29] = -5;
        nArray2[30] = 14;
        nArray2[31] = 31;
        nArray2[32] = 43;
        nArray2[33] = 43;
        nArray2[34] = 19;
        nArray2[35] = -6;
        nArray2[36] = -29;
        nArray2[37] = -43;
        nArray2[38] = -32;
        nArray2[39] = -39;
        nArray2[40] = -29;
        nArray2[41] = -21;
        nArray2[42] = -13;
        nArray2[43] = -4;
        nArray2[44] = 19;
        nArray2[45] = 36;
        nArray2[46] = 52;
        nArray2[47] = 35;
        nArray2[48] = 15;
        nArray2[49] = -11;
        nArray2[50] = -30;
        nArray2[51] = -36;
        nArray2[52] = -31;
        nArray2[53] = -30;
        nArray2[54] = -24;
        nArray2[55] = -19;
        nArray2[56] = -13;
        nArray2[58] = 20;
        nArray2[59] = 35;
        nArray2[60] = 46;
        nArray2[61] = 31;
        nArray2[62] = 9;
        nArray2[63] = -17;
        nArray2[64] = -30;
        nArray2[65] = -26;
        nArray2[66] = -28;
        nArray2[67] = -28;
        nArray2[68] = -20;
        nArray2[69] = -17;
        nArray2[70] = -15;
        nArray2[72] = 24;
        nArray2[73] = 46;
        nArray2[74] = 45;
        nArray2[75] = 25;
        nArray2[77] = -28;
        nArray2[78] = -10;
        nArray2[79] = -23;
        nArray2[80] = -27;
        nArray2[81] = -23;
        nArray2[82] = -21;
        nArray2[83] = -22;
        nArray2[84] = -14;
        nArray2[85] = 4;
        nArray2[86] = 29;
        nArray2[87] = 40;
        nArray2[88] = 37;
        nArray2[89] = 17;
        nArray2[90] = -5;
        nArray2[91] = 15;
        nArray2[92] = -9;
        nArray2[93] = -20;
        nArray2[94] = -22;
        nArray2[95] = -23;
        nArray2[96] = -27;
        nArray2[97] = -21;
        nArray2[98] = -13;
        nArray2[99] = 12;
        nArray2[100] = 31;
        nArray2[101] = 40;
        nArray2[102] = 33;
        nArray2[103] = 15;
        nArray2[104] = 29;
        nArray2[105] = 13;
        nArray2[106] = -10;
        nArray2[107] = -18;
        nArray2[108] = -22;
        nArray2[109] = -27;
        nArray2[110] = -30;
        nArray2[111] = -25;
        nArray2[112] = -11;
        nArray2[113] = 16;
        nArray2[114] = 36;
        nArray2[115] = 42;
        nArray2[116] = 31;
        nArray2[117] = 45;
        nArray2[118] = 28;
        nArray2[119] = 8;
        nArray2[120] = -10;
        nArray2[121] = -20;
        nArray2[122] = -28;
        nArray2[123] = -33;
        nArray2[124] = -33;
        nArray2[125] = -26;
        nArray2[126] = 9;
        nArray2[127] = 22;
        nArray2[128] = 45;
        nArray2[129] = 44;
        nArray2[130] = 41;
        nArray2[131] = 45;
        nArray2[132] = 19;
        nArray2[133] = 9;
        nArray2[134] = -9;
        nArray2[135] = -21;
        nArray2[136] = -34;
        nArray2[137] = -34;
        nArray2[138] = -34;
        nArray2[139] = -19;
        nArray2[140] = -4;
        nArray2[141] = 26;
        nArray2[142] = 42;
        nArray2[143] = 22;
        nArray2[144] = 36;
        nArray2[145] = 42;
        nArray2[146] = 25;
        nArray2[147] = 14;
        nArray2[149] = -18;
        nArray2[150] = -27;
        nArray2[151] = -34;
        nArray2[152] = -32;
        nArray2[153] = -21;
        nArray2[154] = -7;
        nArray2[155] = 26;
        nArray2[157] = 11;
        nArray2[158] = 26;
        nArray2[159] = 39;
        nArray2[160] = 36;
        nArray2[161] = 25;
        nArray2[162] = 8;
        nArray2[163] = -8;
        nArray2[164] = -26;
        nArray2[165] = -38;
        nArray2[166] = -38;
        nArray2[167] = -28;
        nArray2[168] = -2;
        perturbJup2 = nArray2;
        perturbJup3 = new int[]{41, 33, 19, 4, -13, -28, -37, -42, -27, -9, 16, 30, 44, 27, 33, 33, 23, 15, 3, -22, -36, -43, -25, -10, 14, 27, 13, 23, 32, 33, 27, 22, 8, -22, -37, -42, -27, -10, 12, -5, 10, 18, 23, 34, 32, 25, 5, -26, -45, -47, -26, -5, -17, -2, 10, 18, 26, 35, 37, 22, -4, -27, -44, -42, -27, -33, -15, -1, 7, 16, 22, 36, 35, 16, -7, -28, -40, -36, -44, -27, -12, -6, 4, 16, 32, 54, 31, 12, -10, -31, -43, -37, -37, -24, -12, -2, 7, 17, 30, 42, 24, 11, -15, -33, -31, -36, -35, -24, -13, -4, 7, 21, 35, 38, 20, 6, -15, -19, -32, -40, -31, -21, -18, -5, 12, 25, 38, 42, 26, -6, 11, -14, -30, -44, -33, -27, -13, -1, 15, 29, 42, 39, 18, 31, 13, -6, -22, -34, -29, -27, -27, 9, 15, 25, 40, 35, 40, 31, 18, 6, -15, -28, -38, -40, -29, -13, 15, 25, 40};
        perturbSat1 = new int[]{57, 59, 57, 60, 56, 48, 42, 41, 41, 42, 46, 50, 55, 61, 64, 70, 73, 74, 66, 61, 57, 55, 55, 55, 56, 56, 58, 61, 65, 71, 76, 76, 72, 66, 63, 61, 60, 58, 56, 55, 55, 58, 63, 68, 74, 73, 71, 67, 63, 61, 57, 55, 52, 51, 51, 55, 61, 67, 70, 70, 67, 62, 58, 55, 53, 49, 48, 47, 48, 52, 58, 63, 65, 63, 60, 56, 52, 50, 48, 46, 44, 43, 45, 49, 54, 57, 58, 56, 53, 50, 48, 46, 44, 41, 40, 39, 40, 45, 48, 50, 51, 50, 48, 46, 44, 42, 39, 37, 36, 35, 36, 39, 43, 45, 46, 45, 44, 42, 40, 36, 34, 32, 31, 31, 33, 37, 39, 41, 42, 44, 42, 39, 37, 33, 30, 29, 29, 30, 32, 34, 37, 40, 44, 45, 45, 43, 39, 35, 30, 29, 30, 33, 35, 38, 42, 45, 55, 57, 61, 56, 49, 45, 42, 40, 42, 43, 46, 50, 54};
        perturbSat2 = new int[]{33, 37, 44, 52, 60, 66, 67, 65, 57, 46, 37, 32, 31, 34, 40, 50, 60, 67, 70, 67, 60, 50, 40, 33, 29, 31, 36, 42, 50, 60, 68, 72, 68, 59, 47, 38, 34, 34, 37, 45, 48, 52, 57, 62, 65, 63, 55, 45, 40, 39, 42, 44, 54, 55, 54, 53, 54, 55, 54, 49, 45, 43, 44, 48, 54, 57, 60, 55, 51, 46, 45, 44, 46, 47, 48, 51, 55, 57, 57, 59, 56, 50, 43, 39, 39, 44, 49, 52, 55, 57, 57, 53, 54, 52, 49, 44, 40, 41, 45, 51, 55, 57, 54, 54, 46, 44, 45, 47, 47, 48, 48, 51, 55, 57, 55, 51, 47, 37, 35, 37, 45, 52, 57, 60, 59, 58, 56, 52, 45, 39, 31, 29, 33, 43, 55, 65, 69, 66, 60, 55, 48, 40, 34, 32, 30, 35, 45, 56, 68, 72, 69, 60, 52, 43, 36, 32, 33, 36, 43, 51, 59, 65, 68, 65, 57, 47, 38, 34, 31};
        perturbSat3 = new int[]{51, 60, 66, 67, 62, 56, 46, 40, 34, 31, 37, 45, 53, 59, 66, 70, 67, 60, 51, 40, 33, 30, 33, 40, 50, 60, 60, 65, 67, 66, 59, 50, 38, 31, 30, 35, 43, 52, 59, 58, 59, 60, 59, 55, 49, 40, 36, 36, 43, 50, 55, 57, 55, 52, 50, 50, 49, 47, 45, 45, 45, 50, 55, 56, 55, 53, 48, 44, 42, 43, 46, 50, 53, 55, 56, 57, 55, 53, 51, 47, 41, 38, 40, 47, 55, 59, 61, 59, 56, 53, 51, 48, 42, 44, 42, 44, 48, 55, 58, 58, 55, 51, 50, 48, 45, 49, 50, 50, 50, 51, 53, 55, 54, 50, 45, 43, 45, 46, 52, 59, 62, 61, 56, 53, 50, 46, 42, 39, 38, 41, 45, 54, 65, 71, 71, 63, 53, 43, 39, 35, 34, 35, 42, 48, 55, 65, 71, 70, 63, 51, 40, 34, 31, 33, 38, 44, 51, 60, 66, 68, 65, 58, 46, 38, 33, 32, 37, 46, 54};
        perturbSat4 = new int[]{83, 82, 80, 78, 75, 74, 73, 73, 75, 77, 79, 81, 83, 81, 82, 82, 81, 80, 77, 75, 72, 72, 75, 77, 80, 81, 77, 70, 77, 75, 75, 75, 70, 67, 65, 64, 65, 68, 70, 50, 51, 54, 58, 60, 61, 59, 56, 52, 49, 47, 47, 49, 30, 32, 34, 37, 40, 42, 42, 40, 36, 31, 30, 29, 30, 17, 18, 19, 20, 22, 24, 27, 26, 21, 19, 17, 15, 17, 13, 13, 12, 12, 14, 15, 17, 18, 17, 16, 15, 14, 13, 20, 19, 18, 17, 17, 18, 20, 21, 24, 24, 23, 21, 20, 31, 31, 32, 32, 31, 31, 32, 35, 37, 38, 36, 34, 32, 50, 50, 53, 53, 52, 51, 51, 52, 53, 53, 52, 50, 50, 68, 69, 71, 72, 72, 70, 69, 68, 68, 68, 70, 70, 67, 80, 80, 79, 80, 80, 79, 77, 76, 74, 76, 77, 80, 80, 83, 83, 80, 78, 75, 75, 76, 76, 76, 76, 79, 81, 83};
    }
}

