/*
 * Decompiled with CFR 0.152.
 */
package astro;

import astro.TimeSpan;
import astro.UdMath;

public class ATime {
    private int nYear;
    private int nMonth;
    private int nDay;
    private int nHour;
    private int nMin;
    private double fSec;
    private double fJd;
    private double fTimezone;
    private double fT;
    private double fT2;
    private static final String[] strMonthAbbr = new String[]{"Jan.", "Feb.", "Mar.", "Apr.", "May ", "June", "July", "Aug.", "Sep.", "Oct.", "Nov.", "Dec."};
    public static final int F_INCTIME = 1;
    public static final int F_DECTIME = -1;

    public static String getMonthAbbr(int n) {
        return strMonthAbbr[n - 1];
    }

    private double makeJd() {
        double d;
        int n = this.nYear;
        int n2 = this.nMonth;
        double d2 = (double)this.nDay + (double)this.nHour / 24.0 + (double)this.nMin / 24.0 / 60.0 + this.fSec / 24.0 / 60.0 / 60.0;
        if (n2 < 3) {
            n2 += 12;
            --n;
        }
        if ((d = Math.floor(365.25 * (double)n) + Math.floor(30.59 * (double)(n2 - 2)) + d2 + 1721086.5) > 2299160.5) {
            d += Math.floor((double)n / 400.0) - Math.floor((double)n / 100.0) + 2.0;
        }
        return d;
    }

    private double makeT() {
        double d = (this.fJd - 2442412.5) / 365.25;
        double d2 = d + (0.0317 * d + 1.43) * 1.0E-6;
        return d2;
    }

    private double makeT2() {
        double d = (this.fJd - 2451545.0) / 36525.0;
        return d;
    }

    private void getDate(double d) {
        double d2;
        double d3 = Math.floor(d += 0.5);
        if (d3 >= 2299160.5) {
            d2 = Math.floor((d3 - 1867216.25) / 36524.25);
            d3 += d2 - Math.floor(d2 / 4.0) + 1.0;
        }
        d2 = Math.floor(d3) + 1524.0;
        double d4 = Math.floor((d2 - 122.1) / 365.25);
        double d5 = Math.floor(365.25 * d4);
        double d6 = Math.floor((d2 - d5) / 30.6001);
        double d7 = d2 - d5 - Math.floor(30.6001 * d6) + (d - Math.floor(d));
        this.nMonth = (int)Math.floor(d6 - (double)(d6 >= 13.5 ? 13 : 1) + 0.5);
        this.nYear = (int)Math.floor(d4 - (double)(this.nMonth > 2 ? 4716 : 4715) + 0.5);
        this.nDay = (int)Math.floor(d7);
        double d8 = (d7 - (double)this.nDay) * 24.0;
        this.nHour = (int)Math.floor(d8);
        double d9 = (d8 - (double)this.nHour) * 60.0;
        this.nMin = (int)Math.floor(d9);
        this.fSec = (d9 - (double)this.nMin) * 60.0;
    }

    public void changeDate(TimeSpan timeSpan, int n) {
        int n2;
        double d = (double)this.nHour * 60.0 * 60.0 + (double)this.nMin * 60.0 + this.fSec;
        double d2 = (double)timeSpan.nHour * 60.0 * 60.0 + (double)timeSpan.nMin * 60.0 + timeSpan.fSec;
        if ((d += n == 1 ? d2 : -d2) >= 0.0 && d < 86400.0) {
            n2 = 0;
        } else if (d >= 86400.0) {
            n2 = (int)Math.floor(d / 24.0 / 60.0 / 60.0);
            d = UdMath.fmod(d, 86400.0);
        } else {
            n2 = (int)Math.ceil(d / 24.0 / 60.0 / 60.0) - 1;
            d = UdMath.fmod(d, 86400.0) + 86400.0;
        }
        int n3 = (int)Math.floor(d / 60.0 / 60.0);
        int n4 = (int)Math.floor(d / 60.0) - n3 * 60;
        double d3 = d - ((double)n3 * 60.0 * 60.0 + (double)n4 * 60.0);
        ATime aTime = new ATime(this.getYear(), this.getMonth(), this.getDay(), 12, 0, 0.0, 0.0);
        double d4 = aTime.getJd();
        aTime = new ATime(d4 += (double)(n == 1 ? n2 + timeSpan.nDay : n2 - timeSpan.nDay), 0.0);
        int n5 = aTime.getYear();
        int n6 = aTime.getMonth();
        int n7 = aTime.getDay();
        if ((n6 += n == 1 ? timeSpan.nMonth : -timeSpan.nMonth) < 1) {
            n5 -= n6 / 12 + 1;
            n6 = 12 + n6 % 12;
        } else if (n6 > 12) {
            n5 += n6 / 12;
            n6 = 1 + (n6 - 1) % 12;
        }
        if ((n5 += n == 1 ? timeSpan.nYear : -timeSpan.nYear) == 1582 && n6 == 10) {
            if (n7 >= 5 && n7 < 10) {
                n7 = 4;
            } else if (n7 >= 10 && n7 < 15) {
                n7 = 15;
            }
        }
        aTime = new ATime(n5, n6, n7, 12, 0, 0.0, 0.0);
        n5 = aTime.getYear();
        n6 = aTime.getMonth();
        n7 = aTime.getDay();
        this.nYear = n5;
        this.nMonth = n6;
        this.nDay = n7;
        this.nHour = n3;
        this.nMin = n4;
        this.fSec = d3;
        this.fJd = this.makeJd() - this.fTimezone / 24.0;
        this.fT = this.makeT();
        this.fT2 = this.makeT2();
    }

    public ATime(int n, int n2, int n3, int n4, int n5, double d, double d2) {
        this.nYear = n;
        this.nMonth = n2;
        this.nDay = n3;
        this.nHour = n4;
        this.nMin = n5;
        this.fSec = d;
        this.fJd = this.makeJd() - d2 / 24.0;
        this.fTimezone = d2;
        this.fT = this.makeT();
        this.fT2 = this.makeT2();
    }

    public ATime(int n, int n2, double d, double d2) {
        this.nYear = n;
        this.nMonth = n2;
        this.nDay = (int)Math.floor(d);
        double d3 = (d - (double)this.nDay) * 24.0;
        this.nHour = (int)Math.floor(d3);
        double d4 = (d3 - (double)this.nHour) * 60.0;
        this.nMin = (int)Math.floor(d4);
        this.fSec = (d4 - (double)this.nMin) * 60.0;
        this.fJd = this.makeJd() - d2 / 24.0;
        this.fTimezone = d2;
        this.fT = this.makeT();
        this.fT2 = this.makeT2();
    }

    public ATime(double d, double d2) {
        this.fJd = d;
        this.fTimezone = d2;
        this.getDate(d + d2 / 24.0);
        this.fT = this.makeT();
        this.fT2 = this.makeT2();
    }

    public ATime(ATime aTime) {
        this.nYear = aTime.nYear;
        this.nMonth = aTime.nMonth;
        this.nDay = aTime.nDay;
        this.nHour = aTime.nHour;
        this.nMin = aTime.nMin;
        this.fSec = aTime.fSec;
        this.fJd = aTime.fJd;
        this.fTimezone = aTime.fTimezone;
        this.fT = aTime.fT;
        this.fT2 = aTime.fT2;
    }

    public int getYear() {
        return this.nYear;
    }

    public int getMonth() {
        return this.nMonth;
    }

    public int getDay() {
        return this.nDay;
    }

    public int getHour() {
        return this.nHour;
    }

    public int getMinute() {
        return this.nMin;
    }

    public double getSecond() {
        return this.fSec;
    }

    public double getTimezone() {
        return this.fTimezone;
    }

    public double getJd() {
        return this.fJd;
    }

    public double getT() {
        return this.fT;
    }

    public double getT2() {
        return this.fT2;
    }

    public static double getEp(double d) {
        double d2 = (d - 2451545.0) / 36525.0;
        if (d2 > 30.0) {
            d2 = 30.0;
        } else if (d2 < -30.0) {
            d2 = -30.0;
        }
        double d3 = 23.43929111 - 0.013004166666666667 * d2 - 1.638888888888889E-7 * d2 * d2 + 5.03611111111111E-7 * d2 * d2 * d2;
        return d3 * Math.PI / 180.0;
    }

    public String toString() {
        return new String(String.valueOf(Integer.toString(this.nYear)) + "/" + Integer.toString(this.nMonth) + "/" + Integer.toString(this.nDay) + " " + Integer.toString(this.nHour) + ":" + Integer.toString(this.nMin) + ":" + Double.toString(this.fSec) + " = " + Double.toString(this.fJd) + " (TZ:" + Double.toString(this.fTimezone) + ")");
    }
}

