/*
 * Decompiled with CFR 0.152.
 */
import astro.ATime;
import astro.Comet;
import astro.CometOrbit;
import astro.Matrix;
import astro.Planet;
import astro.PlanetOrbit;
import astro.Xyz;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

class OrbitCanvas
extends Canvas {
    private Comet object;
    private CometOrbit objectOrbit;
    private PlanetOrbit[] planetOrbit;
    private double epochPlanetOrbit;
    private ATime atime;
    private Xyz objectPos;
    private Xyz[] planetPos;
    private int CenterObjectSelected;
    private boolean[] OrbitDisplay;
    private double fRotateH;
    private double fRotateV;
    private double fZoom = 5.0;
    private Matrix mtxToEcl;
    private double epochToEcl;
    private Matrix mtxRotate;
    private int nX0;
    private int nY0;
    private Dimension sizeCanvas;
    private Color colorObjectOrbitUpper = new Color(62975);
    private Color colorObjectOrbitLower = new Color(255);
    private Color colorObject = new Color(65535);
    private Color colorObjectName = new Color(52428);
    private Color colorPlanetOrbitUpper = new Color(0xFFFFFF);
    private Color colorPlanetOrbitLower = new Color(0x808080);
    private Color colorPlanet = new Color(65280);
    private Color colorPlanetName = new Color(43520);
    private Color colorSun = new Color(0xD04040);
    private Color colorAxisPlus = new Color(0xFFFF00);
    private Color colorAxisMinus = new Color(0x555500);
    private Color colorInformation = new Color(0xFFFFFF);
    private Font fontObjectName = new Font("Helvetica", 1, 14);
    private Font fontPlanetName = new Font("Helvetica", 0, 14);
    private Font fontInformation = new Font("Helvetica", 1, 14);
    Image offscreen;
    boolean bPlanetName;
    boolean bObjectName;
    boolean bDistanceLabel;
    boolean bDateLabel;

    public OrbitCanvas(Comet comet, ATime aTime) {
        this.planetPos = new Xyz[9];
        this.OrbitDisplay = new boolean[11];
        this.object = comet;
        this.objectOrbit = new CometOrbit(comet, 120);
        this.planetOrbit = new PlanetOrbit[9];
        this.updatePlanetOrbit(aTime);
        this.updateRotationMatrix(aTime);
        this.atime = aTime;
        this.setDate(this.atime);
        this.offscreen = null;
        this.bPlanetName = false;
        this.bObjectName = false;
        this.bDistanceLabel = true;
        this.bDateLabel = true;
        this.repaint();
    }

    private void updatePlanetOrbit(ATime aTime) {
        int n = 1;
        while (n <= 9) {
            this.planetOrbit[n - 1] = new PlanetOrbit(n, aTime, 48);
            ++n;
        }
        this.epochPlanetOrbit = aTime.getJd();
    }

    private void updateRotationMatrix(ATime aTime) {
        Matrix matrix = Matrix.PrecMatrix(2451545.0, aTime.getJd());
        Matrix matrix2 = Matrix.RotateX(ATime.getEp(aTime.getJd()));
        this.mtxToEcl = matrix2.Mul(matrix);
        this.epochToEcl = aTime.getJd();
    }

    public void setRotateHorz(int n) {
        this.fRotateH = n;
    }

    public void setRotateVert(int n) {
        this.fRotateV = n;
    }

    public void setZoom(int n) {
        this.fZoom = n;
    }

    public void setDate(ATime aTime) {
        this.atime = aTime;
        this.objectPos = this.object.GetPos(aTime.getJd());
        int n = 0;
        while (n < 9) {
            this.planetPos[n] = Planet.getPos(1 + n, aTime);
            ++n;
        }
    }

    public void switchPlanetName(boolean bl) {
        this.bPlanetName = bl;
    }

    public void SelectOrbits(boolean[] blArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            this.OrbitDisplay[n2] = blArray[n2];
            ++n2;
        }
    }

    public void SelectCenterObject(int n) {
        this.CenterObjectSelected = n;
    }

    public void switchObjectName(boolean bl) {
        this.bObjectName = bl;
    }

    public void switchDistanceLabel(boolean bl) {
        this.bDistanceLabel = bl;
    }

    public void switchDateLabel(boolean bl) {
        this.bDateLabel = bl;
    }

    private Point getDrawPoint(Xyz xyz) {
        double d = this.fZoom * (double)this.sizeCanvas.width / 600.0 * (1.0 + xyz.fZ / 250.0);
        int n = this.nX0 + (int)Math.round(xyz.fX * d);
        int n2 = this.nY0 - (int)Math.round(xyz.fY * d);
        return new Point(n, n2);
    }

    private void drawPlanetOrbit(Graphics graphics, PlanetOrbit planetOrbit, Color color, Color color2) {
        Xyz xyz = planetOrbit.getAt(0).Rotate(this.mtxToEcl).Rotate(this.mtxRotate);
        Point point = this.getDrawPoint(xyz);
        int n = 1;
        while (n <= planetOrbit.getDivision()) {
            xyz = planetOrbit.getAt(n).Rotate(this.mtxToEcl);
            if (xyz.fZ >= 0.0) {
                graphics.setColor(color);
            } else {
                graphics.setColor(color2);
            }
            xyz = xyz.Rotate(this.mtxRotate);
            Point point2 = this.getDrawPoint(xyz);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
            point = point2;
            ++n;
        }
    }

    private void drawEarthOrbit(Graphics graphics, PlanetOrbit planetOrbit, Color color, Color color2) {
        Xyz xyz = planetOrbit.getAt(0).Rotate(this.mtxToEcl).Rotate(this.mtxRotate);
        Point point = this.getDrawPoint(xyz);
        int n = 1;
        while (n <= planetOrbit.getDivision()) {
            xyz = planetOrbit.getAt(n).Rotate(this.mtxToEcl);
            graphics.setColor(color);
            xyz = xyz.Rotate(this.mtxRotate);
            Point point2 = this.getDrawPoint(xyz);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
            point = point2;
            ++n;
        }
    }

    private void drawPlanetBody(Graphics graphics, Xyz xyz, String string) {
        Xyz xyz2 = xyz.Rotate(this.mtxRotate);
        Point point = this.getDrawPoint(xyz2);
        graphics.setColor(this.colorPlanet);
        graphics.fillArc(point.x - 2, point.y - 2, 5, 5, 0, 360);
        if (this.bPlanetName) {
            graphics.setColor(this.colorPlanetName);
            graphics.drawString(string, point.x + 5, point.y);
        }
    }

    private void drawEclipticAxis(Graphics graphics) {
        graphics.setColor(this.colorAxisMinus);
        Xyz xyz = new Xyz(-50.0, 0.0, 0.0).Rotate(this.mtxRotate);
        Point point = this.getDrawPoint(xyz);
        graphics.drawLine(this.nX0, this.nY0, point.x, point.y);
        xyz = new Xyz(0.0, 0.0, -50.0).Rotate(this.mtxRotate);
        point = this.getDrawPoint(xyz);
        graphics.drawLine(this.nX0, this.nY0, point.x, point.y);
        graphics.setColor(this.colorAxisPlus);
        xyz = new Xyz(50.0, 0.0, 0.0).Rotate(this.mtxRotate);
        point = this.getDrawPoint(xyz);
        graphics.drawLine(this.nX0, this.nY0, point.x, point.y);
        xyz = new Xyz(0.0, 0.0, 50.0).Rotate(this.mtxRotate);
        point = this.getDrawPoint(xyz);
        graphics.drawLine(this.nX0, this.nY0, point.x, point.y);
    }

    public void update(Graphics graphics) {
        Point point;
        Xyz xyz;
        Matrix matrix = Matrix.RotateZ(this.fRotateH * Math.PI / 180.0);
        Matrix matrix2 = Matrix.RotateX(this.fRotateV * Math.PI / 180.0);
        this.mtxRotate = matrix2.Mul(matrix);
        this.nX0 = this.sizeCanvas.width / 2;
        this.nY0 = this.sizeCanvas.height / 2;
        if (Math.abs(this.epochToEcl - this.atime.getJd()) > 1826.2110000000002) {
            this.updateRotationMatrix(this.atime);
        }
        if (this.CenterObjectSelected == 1) {
            xyz = this.objectOrbit.getAt(0).Rotate(this.mtxToEcl).Rotate(this.mtxRotate);
            xyz = this.objectPos.Rotate(this.mtxToEcl).Rotate(this.mtxRotate);
            point = this.getDrawPoint(xyz);
            this.nX0 = this.sizeCanvas.width - point.x;
            this.nY0 = this.sizeCanvas.height - point.y;
            if (Math.abs(this.epochToEcl - this.atime.getJd()) > 1826.2110000000002) {
                this.updateRotationMatrix(this.atime);
            }
        } else if (this.CenterObjectSelected > 1) {
            xyz = this.planetPos[this.CenterObjectSelected - 2].Rotate(this.mtxRotate);
            point = this.getDrawPoint(xyz);
            this.nX0 = this.sizeCanvas.width - point.x;
            this.nY0 = this.sizeCanvas.height - point.y;
            if (Math.abs(this.epochToEcl - this.atime.getJd()) > 1826.2110000000002) {
                this.updateRotationMatrix(this.atime);
            }
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        graphics2.setColor(Color.black);
        graphics2.fillRect(0, 0, this.sizeCanvas.width - 1, this.sizeCanvas.height - 1);
        this.drawEclipticAxis(graphics2);
        graphics2.setColor(this.colorSun);
        graphics2.fillArc(this.nX0 - 2, this.nY0 - 2, 5, 5, 0, 360);
        xyz = this.objectOrbit.getAt(0).Rotate(this.mtxToEcl).Rotate(this.mtxRotate);
        Point point2 = this.getDrawPoint(xyz);
        if (this.OrbitDisplay[0] || this.OrbitDisplay[1]) {
            int n = 1;
            while (n <= this.objectOrbit.getDivision()) {
                xyz = this.objectOrbit.getAt(n).Rotate(this.mtxToEcl);
                if (xyz.fZ >= 0.0) {
                    graphics2.setColor(this.colorObjectOrbitUpper);
                } else {
                    graphics2.setColor(this.colorObjectOrbitLower);
                }
                xyz = xyz.Rotate(this.mtxRotate);
                Point point3 = this.getDrawPoint(xyz);
                graphics2.drawLine(point2.x, point2.y, point3.x, point3.y);
                point2 = point3;
                ++n;
            }
        }
        xyz = this.objectPos.Rotate(this.mtxToEcl).Rotate(this.mtxRotate);
        point2 = this.getDrawPoint(xyz);
        graphics2.setColor(this.colorObject);
        graphics2.fillArc(point2.x - 2, point2.y - 2, 5, 5, 0, 360);
        graphics2.setFont(this.fontObjectName);
        if (this.bObjectName) {
            graphics2.setColor(this.colorObjectName);
            graphics2.drawString(this.object.getName(), point2.x + 5, point2.y);
        }
        if (Math.abs(this.epochPlanetOrbit - this.atime.getJd()) > 1826.2110000000002) {
            this.updatePlanetOrbit(this.atime);
        }
        graphics2.setFont(this.fontPlanetName);
        if (this.OrbitDisplay[0] || this.OrbitDisplay[10]) {
            this.drawPlanetOrbit(graphics2, this.planetOrbit[8], this.colorPlanetOrbitUpper, this.colorPlanetOrbitLower);
        }
        this.drawPlanetBody(graphics2, this.planetPos[8], "Pluto");
        if (this.OrbitDisplay[0] || this.OrbitDisplay[9]) {
            this.drawPlanetOrbit(graphics2, this.planetOrbit[7], this.colorPlanetOrbitUpper, this.colorPlanetOrbitLower);
        }
        this.drawPlanetBody(graphics2, this.planetPos[7], "Neptune");
        if (this.OrbitDisplay[0] || this.OrbitDisplay[8]) {
            this.drawPlanetOrbit(graphics2, this.planetOrbit[6], this.colorPlanetOrbitUpper, this.colorPlanetOrbitLower);
        }
        this.drawPlanetBody(graphics2, this.planetPos[6], "Uranus");
        if (this.OrbitDisplay[0] || this.OrbitDisplay[7]) {
            this.drawPlanetOrbit(graphics2, this.planetOrbit[5], this.colorPlanetOrbitUpper, this.colorPlanetOrbitLower);
        }
        this.drawPlanetBody(graphics2, this.planetPos[5], "Saturn");
        if (this.OrbitDisplay[0] || this.OrbitDisplay[6]) {
            this.drawPlanetOrbit(graphics2, this.planetOrbit[4], this.colorPlanetOrbitUpper, this.colorPlanetOrbitLower);
        }
        this.drawPlanetBody(graphics2, this.planetPos[4], "Jupiter");
        if (this.fZoom * 1.524 >= 7.5) {
            if (this.OrbitDisplay[0] || this.OrbitDisplay[5]) {
                this.drawPlanetOrbit(graphics2, this.planetOrbit[3], this.colorPlanetOrbitUpper, this.colorPlanetOrbitLower);
            }
            this.drawPlanetBody(graphics2, this.planetPos[3], "Mars");
        }
        if (this.fZoom >= 7.5) {
            if (this.OrbitDisplay[0] || this.OrbitDisplay[4]) {
                this.drawEarthOrbit(graphics2, this.planetOrbit[2], this.colorPlanetOrbitUpper, this.colorPlanetOrbitUpper);
            }
            this.drawPlanetBody(graphics2, this.planetPos[2], "Earth");
        }
        if (this.fZoom * 0.723 >= 7.5) {
            if (this.OrbitDisplay[0] || this.OrbitDisplay[3]) {
                this.drawPlanetOrbit(graphics2, this.planetOrbit[1], this.colorPlanetOrbitUpper, this.colorPlanetOrbitLower);
            }
            this.drawPlanetBody(graphics2, this.planetPos[1], "Venus");
        }
        if (this.fZoom * 0.387 >= 7.5) {
            if (this.OrbitDisplay[0] || this.OrbitDisplay[2]) {
                this.drawPlanetOrbit(graphics2, this.planetOrbit[0], this.colorPlanetOrbitUpper, this.colorPlanetOrbitLower);
            }
            this.drawPlanetBody(graphics2, this.planetPos[0], "Mercury");
        }
        graphics2.setFont(this.fontInformation);
        graphics2.setColor(this.colorInformation);
        FontMetrics fontMetrics = graphics2.getFontMetrics();
        point2.x = fontMetrics.charWidth('A');
        point2.y = 2 * fontMetrics.charWidth('A');
        graphics2.drawString(this.object.getName(), point2.x, point2.y);
        if (this.bDistanceLabel) {
            xyz = this.objectPos.Rotate(this.mtxToEcl).Rotate(this.mtxRotate);
            Xyz xyz2 = this.planetPos[2].Rotate(this.mtxRotate);
            double d = Math.sqrt(xyz.fX * xyz.fX + xyz.fY * xyz.fY + xyz.fZ * xyz.fZ) + 5.0E-4;
            d = (double)((int)(d * 1000.0)) / 1000.0;
            double d2 = xyz.fX - xyz2.fX;
            double d3 = xyz.fY - xyz2.fY;
            double d4 = xyz.fZ - xyz2.fZ;
            double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4) + 5.0E-4;
            d5 = (double)((int)(d5 * 1000.0)) / 1000.0;
            String string = "Earth Distance: " + d5 + " AU";
            point2.x = fontMetrics.charWidth('A');
            point2.y = this.sizeCanvas.height - fontMetrics.getDescent() - fontMetrics.getHeight();
            graphics2.drawString(string, point2.x, point2.y);
            string = "Sun Distance  : " + d + " AU";
            point2.x = fontMetrics.charWidth('A');
            point2.y = this.sizeCanvas.height - fontMetrics.getDescent() - fontMetrics.getHeight() / 3;
            graphics2.drawString(string, point2.x, point2.y);
        }
        if (this.bDateLabel) {
            String string = String.valueOf(ATime.getMonthAbbr(this.atime.getMonth())) + " " + this.atime.getDay() + ", " + this.atime.getYear();
            point2.x = this.sizeCanvas.width - fontMetrics.stringWidth(string) - fontMetrics.charWidth('A');
            point2.y = this.sizeCanvas.height - fontMetrics.getDescent() - fontMetrics.getHeight() / 3;
            graphics2.drawString(string, point2.x, point2.y);
        }
        graphics2.clearRect(0, this.sizeCanvas.height - 1, this.sizeCanvas.width, this.sizeCanvas.height);
        graphics2.clearRect(this.sizeCanvas.width - 1, 0, this.sizeCanvas.width, this.sizeCanvas.height);
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    public void paint(Graphics graphics) {
        if (this.offscreen == null) {
            this.sizeCanvas = this.size();
            this.offscreen = this.createImage(this.sizeCanvas.width, this.sizeCanvas.height);
            this.update(graphics);
            return;
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
    }
}

