/*
 * Decompiled with CFR 0.152.
 */
import astro.ATime;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.TextComponent;
import java.awt.TextField;
import java.util.Date;

class DateDialog
extends Frame {
    protected TextField tfYear;
    protected TextField tfDate;
    protected Choice choiceMonth;
    protected Button buttonOk;
    protected Button buttonCancel;
    protected Button buttonToday;
    protected OrbitViewer objectOrbit;

    public DateDialog(OrbitViewer orbitViewer, ATime aTime) {
        this.objectOrbit = orbitViewer;
        this.setLayout(new GridLayout(2, 3, 4, 4));
        ((Component)this).setFont(new Font("Dialog", 0, 14));
        this.choiceMonth = new Choice();
        int n = 0;
        while (n < 12) {
            this.choiceMonth.addItem(ATime.getMonthAbbr(n + 1));
            ++n;
        }
        this.choiceMonth.select(aTime.getMonth() - 1);
        this.add(this.choiceMonth);
        Integer n2 = new Integer(aTime.getDay());
        this.tfDate = new TextField(n2.toString(), 2);
        this.add(this.tfDate);
        Integer n3 = new Integer(aTime.getYear());
        this.tfYear = new TextField(n3.toString(), 4);
        this.add(this.tfYear);
        this.buttonToday = new Button("Today");
        this.add(this.buttonToday);
        this.buttonOk = new Button("OK");
        this.add(this.buttonOk);
        this.buttonCancel = new Button("Cancel");
        this.add(this.buttonCancel);
        this.pack();
        this.setTitle("Date");
        this.setResizable(false);
        this.show();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 1001) {
            ATime aTime = null;
            if (event.target == this.buttonOk) {
                int n = Integer.valueOf(this.tfYear.getText());
                int n2 = this.choiceMonth.getSelectedIndex() + 1;
                int n3 = Integer.valueOf(this.tfDate.getText());
                if (n >= 1600 && n <= 2199 && n2 >= 1 && n2 <= 12 && n3 >= 1 && n3 <= 31) {
                    aTime = new ATime(n, n2, n3, 0.0);
                }
            } else {
                if (event.target == this.buttonToday) {
                    Date date = new Date();
                    this.choiceMonth.select(date.getMonth());
                    ((TextComponent)this.tfDate).setText(Integer.toString(date.getDate()));
                    ((TextComponent)this.tfYear).setText(Integer.toString(date.getYear() + 1900));
                    return false;
                }
                if (event.target != this.buttonCancel) {
                    return false;
                }
            }
            this.dispose();
            this.objectOrbit.endDateDialog(aTime);
            return true;
        }
        return false;
    }
}

