/*
 * Decompiled with CFR 0.152.
 */
package astro;

import astro.ATime;

public class Matrix {
    public double fA11;
    public double fA12;
    public double fA13;
    public double fA21;
    public double fA22;
    public double fA23;
    public double fA31;
    public double fA32;
    public double fA33;
    static final double fGeneralPrec = 0.013888888888888888;
    static final double fPrecLimit = 30.0;

    public Matrix() {
        this.fA33 = 0.0;
        this.fA32 = 0.0;
        this.fA31 = 0.0;
        this.fA23 = 0.0;
        this.fA22 = 0.0;
        this.fA21 = 0.0;
        this.fA13 = 0.0;
        this.fA12 = 0.0;
        this.fA11 = 0.0;
    }

    public Matrix(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.fA11 = d;
        this.fA12 = d2;
        this.fA13 = d3;
        this.fA21 = d4;
        this.fA22 = d5;
        this.fA23 = d6;
        this.fA31 = d7;
        this.fA32 = d8;
        this.fA33 = d9;
    }

    public Matrix Mul(Matrix matrix) {
        double d = this.fA11 * matrix.fA11 + this.fA12 * matrix.fA21 + this.fA13 * matrix.fA31;
        double d2 = this.fA21 * matrix.fA11 + this.fA22 * matrix.fA21 + this.fA23 * matrix.fA31;
        double d3 = this.fA31 * matrix.fA11 + this.fA32 * matrix.fA21 + this.fA33 * matrix.fA31;
        double d4 = this.fA11 * matrix.fA12 + this.fA12 * matrix.fA22 + this.fA13 * matrix.fA32;
        double d5 = this.fA21 * matrix.fA12 + this.fA22 * matrix.fA22 + this.fA23 * matrix.fA32;
        double d6 = this.fA31 * matrix.fA12 + this.fA32 * matrix.fA22 + this.fA33 * matrix.fA32;
        double d7 = this.fA11 * matrix.fA13 + this.fA12 * matrix.fA23 + this.fA13 * matrix.fA33;
        double d8 = this.fA21 * matrix.fA13 + this.fA22 * matrix.fA23 + this.fA23 * matrix.fA33;
        double d9 = this.fA31 * matrix.fA13 + this.fA32 * matrix.fA23 + this.fA33 * matrix.fA33;
        return new Matrix(d, d4, d7, d2, d5, d8, d3, d6, d9);
    }

    public Matrix Mul(double d) {
        double d2 = this.fA11 * d;
        double d3 = this.fA21 * d;
        double d4 = this.fA31 * d;
        double d5 = this.fA12 * d;
        double d6 = this.fA22 * d;
        double d7 = this.fA32 * d;
        double d8 = this.fA13 * d;
        double d9 = this.fA23 * d;
        double d10 = this.fA33 * d;
        return new Matrix(d2, d5, d8, d3, d6, d9, d4, d7, d10);
    }

    public static Matrix RotateX(double d) {
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = Math.cos(d);
        double d7 = Math.sin(d);
        double d8 = 0.0;
        double d9 = -Math.sin(d);
        double d10 = Math.cos(d);
        return new Matrix(d2, d3, d4, d5, d6, d7, d8, d9, d10);
    }

    public static Matrix RotateY(double d) {
        double d2 = Math.cos(d);
        double d3 = 0.0;
        double d4 = -Math.sin(d);
        double d5 = 0.0;
        double d6 = 1.0;
        double d7 = 0.0;
        double d8 = Math.sin(d);
        double d9 = 0.0;
        double d10 = Math.cos(d);
        return new Matrix(d2, d3, d4, d5, d6, d7, d8, d9, d10);
    }

    public static Matrix RotateZ(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = 0.0;
        double d5 = -Math.sin(d);
        double d6 = Math.cos(d);
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 1.0;
        return new Matrix(d2, d3, d4, d5, d6, d7, d8, d9, d10);
    }

    public void Invert() {
        double d = 1.0 / (this.fA11 * (this.fA22 * this.fA33 - this.fA23 * this.fA32) - this.fA12 * (this.fA21 * this.fA33 - this.fA23 * this.fA31) + this.fA13 * (this.fA21 * this.fA32 - this.fA22 * this.fA31));
        double d2 = d * (this.fA22 * this.fA33 - this.fA23 * this.fA32);
        double d3 = -1.0 * d * (this.fA12 * this.fA33 - this.fA13 * this.fA32);
        double d4 = d * (this.fA12 * this.fA23 - this.fA13 * this.fA22);
        double d5 = -1.0 * d * (this.fA21 * this.fA33 - this.fA23 * this.fA31);
        double d6 = d * (this.fA11 * this.fA33 - this.fA13 * this.fA31);
        double d7 = -1.0 * d * (this.fA11 * this.fA23 - this.fA13 * this.fA21);
        double d8 = d * (this.fA21 * this.fA32 - this.fA22 * this.fA31);
        double d9 = -1.0 * d * (this.fA11 * this.fA32 - this.fA12 * this.fA31);
        double d10 = d * (this.fA11 * this.fA22 - this.fA12 * this.fA21);
        this.fA11 = d2;
        this.fA12 = d3;
        this.fA13 = d4;
        this.fA21 = d5;
        this.fA22 = d6;
        this.fA23 = d7;
        this.fA31 = d8;
        this.fA32 = d9;
        this.fA33 = d10;
    }

    public static Matrix PrecMatrix(double d, double d2) {
        double d3;
        double d4 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        if (d2 == d) {
            return new Matrix(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        }
        double d5 = (d - 2451545.0) / 36525.0;
        if (d5 < -30.0 || d5 > 30.0) {
            bl = true;
            d3 = d2;
            d2 = d;
            d = d3;
            d5 = (d - 2451545.0) / 36525.0;
        }
        d3 = d5 * d5;
        double d6 = (d2 - d) / 36525.0;
        double d7 = d6;
        if (d7 < -30.0) {
            bl2 = true;
            d6 = -30.0;
            d4 = 1355795.0;
        }
        if (d7 > 30.0) {
            bl2 = true;
            d6 = 30.0;
            d4 = 3547295.0;
        }
        double d8 = d6 * d6;
        double d9 = d8 * d6;
        double d10 = ((2306.2181 + 1.39656 * d5 - 1.39E-4 * d3) * d6 + (0.30188 - 3.44E-4 * d5) * d8 + 0.017998 * d9) / 3600.0;
        double d11 = ((2306.2181 + 1.39656 * d5 - 1.39E-4 * d3) * d6 + (1.09468 + 6.6E-5 * d5) * d8 + 0.018203 * d9) / 3600.0;
        double d12 = ((2004.3109 - 0.8533 * d5 - 2.17E-4 * d3) * d6 - (0.42665 + 2.17E-4 * d5) * d8 - 0.041833 * d9) / 3600.0;
        Matrix matrix = Matrix.RotateZ((90.0 - d10) * Math.PI / 180.0);
        Matrix matrix2 = Matrix.RotateX(d12 * Math.PI / 180.0);
        Matrix matrix3 = matrix2.Mul(matrix);
        matrix = Matrix.RotateZ((-90.0 - d11) * Math.PI / 180.0);
        Matrix matrix4 = matrix.Mul(matrix3);
        if (bl2) {
            double d13 = d7 < -30.0 ? d2 - d + 1095750.0 : d2 - d - 1095750.0;
            double d14 = -d13 / 365.24 * 0.013888888888888888 * Math.PI / 180.0;
            double d15 = ATime.getEp(d4);
            matrix = Matrix.RotateX(d15);
            matrix2 = Matrix.RotateZ(d14);
            matrix3 = matrix2.Mul(matrix);
            matrix2 = Matrix.RotateX(-d15);
            matrix = matrix2.Mul(matrix3);
            matrix4 = matrix.Mul(matrix4);
        }
        if (bl) {
            matrix4.Invert();
        }
        return matrix4;
    }

    public static Matrix VectorConstant(double d, double d2, double d3, ATime aTime) {
        double d4;
        double d5 = aTime.getT();
        double d6 = aTime.getT2();
        if (d6 < -40.0) {
            d4 = 0.41595611758032414;
        } else if (d6 > 40.0) {
            d4 = 0.40234254941476844;
        } else {
            d4 = 23.44253 - 1.3E-4 * d5 + 0.00256 * Math.cos((249.0 - 19.3 * d5) * Math.PI / 180.0) + 1.5E-4 * Math.cos((198.0 + 720.0 * d5) * Math.PI / 180.0);
            d4 *= Math.PI / 180;
        }
        double d7 = Math.sin(d4);
        double d8 = Math.cos(d4);
        double d9 = Math.sin(d);
        double d10 = Math.sin(d2);
        double d11 = Math.sin(d3);
        double d12 = Math.cos(d);
        double d13 = Math.cos(d2);
        double d14 = Math.cos(d3);
        double d15 = d12 * d10 + d9 * d14 * d13;
        double d16 = -d9 * d10 + d12 * d14 * d13;
        double d17 = d12 * d13 - d9 * d14 * d10;
        double d18 = d15 * d8 - d9 * d11 * d7;
        double d19 = d15 * d7 + d9 * d11 * d8;
        double d20 = -d9 * d13 - d12 * d14 * d10;
        double d21 = d16 * d8 - d12 * d11 * d7;
        double d22 = d16 * d7 + d12 * d11 * d8;
        return new Matrix(d17, d20, 0.0, d18, d21, 0.0, d19, d22, 0.0);
    }
}

