/*
 * Decompiled with CFR 0.152.
 */
package astro;

import astro.Comet;
import astro.Matrix;
import astro.UdMath;
import astro.Xyz;

public class CometOrbit {
    private Xyz[] orbit;
    private int nDivision;
    private static final double fMaxOrbit = 90.0;
    private static final double fTolerance = 1.0E-16;

    private void GetOrbitEllip(Comet comet) {
        int n;
        double d = comet.getQ() / (1.0 - comet.getE());
        double d2 = -2.0 * d * comet.getE();
        double d3 = Math.sqrt(1.0 - comet.getE() * comet.getE());
        if (d * (1.0 + comet.getE()) > 90.0) {
            int n2;
            double d4 = Math.acos((1.0 - 90.0 / d) / comet.getE()) / (double)(this.nDivision / 2 * (this.nDivision / 2));
            int n3 = n2 = this.nDivision / 2;
            int n4 = 0;
            while (n4 <= this.nDivision / 2) {
                double d5 = d4 * (double)n4 * (double)n4;
                double d6 = d * (Math.cos(d5) - comet.getE());
                double d7 = d * d3 * Math.sin(d5);
                this.orbit[n3++] = new Xyz(d6, d7, 0.0);
                this.orbit[n2--] = new Xyz(d6, -d7, 0.0);
                ++n4;
            }
            return;
        }
        int n5 = 0;
        int n6 = n = this.nDivision / 2;
        int n7 = this.nDivision;
        double d8 = 0.0;
        int n8 = 0;
        while (n8 <= this.nDivision / 4) {
            double d9 = d * (Math.cos(d8) - comet.getE());
            double d10 = d * d3 * Math.sin(d8);
            this.orbit[n5++] = new Xyz(d9, d10, 0.0);
            this.orbit[n6--] = new Xyz(d2 - d9, d10, 0.0);
            this.orbit[n++] = new Xyz(d2 - d9, -d10, 0.0);
            this.orbit[n7--] = new Xyz(d9, -d10, 0.0);
            ++n8;
            d8 += Math.PI * 2 / (double)this.nDivision;
        }
    }

    private void GetOrbitHyper(Comet comet) {
        int n;
        int n2 = n = this.nDivision / 2;
        double d = Math.sqrt(comet.getE() * comet.getE() - 1.0);
        double d2 = comet.getQ() / (comet.getE() - 1.0);
        double d3 = UdMath.arccosh((90.0 + d2) / (d2 * comet.getE())) / (double)(this.nDivision / 2);
        double d4 = 0.0;
        int n3 = 0;
        while (n3 <= this.nDivision / 2) {
            double d5 = d2 * (comet.getE() - UdMath.cosh(d4));
            double d6 = d2 * d * UdMath.sinh(d4);
            this.orbit[n2++] = new Xyz(d5, d6, 0.0);
            this.orbit[n--] = new Xyz(d5, -d6, 0.0);
            ++n3;
            d4 += d3;
        }
    }

    private void GetOrbitPara(Comet comet) {
        int n;
        int n2 = n = this.nDivision / 2;
        double d = Math.atan(Math.sqrt(90.0 / comet.getQ() - 1.0)) * 2.0 / (double)(this.nDivision / 2);
        double d2 = 0.0;
        int n3 = 0;
        while (n3 <= this.nDivision / 2) {
            double d3 = Math.sin(d2 / 2.0) / Math.cos(d2 / 2.0);
            double d4 = comet.getQ() * (1.0 - d3 * d3);
            double d5 = 2.0 * comet.getQ() * d3;
            this.orbit[n2++] = new Xyz(d4, d5, 0.0);
            this.orbit[n--] = new Xyz(d4, -d5, 0.0);
            ++n3;
            d2 += d;
        }
    }

    public CometOrbit(Comet comet, int n) {
        this.nDivision = n;
        this.orbit = new Xyz[n + 1];
        if (comet.getE() < 0.9999999999999999) {
            this.GetOrbitEllip(comet);
        } else if (comet.getE() > 1.0) {
            this.GetOrbitHyper(comet);
        } else {
            this.GetOrbitPara(comet);
        }
        Matrix matrix = comet.getVectorConstant();
        Matrix matrix2 = Matrix.PrecMatrix(comet.getEquinoxJd(), 2451545.0);
        int n2 = 0;
        while (n2 <= n) {
            this.orbit[n2] = this.orbit[n2].Rotate(matrix).Rotate(matrix2);
            ++n2;
        }
    }

    public int getDivision() {
        return this.nDivision;
    }

    public Xyz getAt(int n) {
        return this.orbit[n];
    }
}

