/*
 * Decompiled with CFR 0.152.
 */
package astro;

import astro.ATime;
import astro.Matrix;
import astro.Xyz;

public class Comet {
    private String strName;
    private double fT;
    private double fE;
    private double fQ;
    private double fPeri;
    private double fNode;
    private double fIncl;
    private double fEquinox;
    private ATime atimeEquinox;
    private Matrix mtxVC;
    private static final double TOLERANCE = 1.0E-12;
    private static final int MAXAPPROX = 80;

    public Comet(String string, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.strName = string;
        this.fT = d;
        this.fE = d2;
        this.fQ = d3;
        this.fPeri = d4;
        this.fNode = d5;
        this.fIncl = d6;
        this.fEquinox = d7;
        int n = (int)Math.floor(d7);
        double d8 = (d7 - (double)n) * 12.0;
        int n2 = (int)Math.floor(d8);
        double d9 = (d8 - (double)n2) * 30.0;
        this.atimeEquinox = new ATime(n, n2, d9, 0.0);
        this.mtxVC = Matrix.VectorConstant(d4, d5, d6, this.atimeEquinox);
    }

    private Xyz CometStatusEllip(double d) {
        double d2;
        double d3;
        if (this.fQ == 0.0) {
            throw new ArithmeticException();
        }
        double d4 = this.fQ / (1.0 - this.fE);
        double d5 = 0.01720209895 * (d - this.fT) / (Math.sqrt(d4) * d4);
        double d6 = d5 + this.fE * Math.sin(d5);
        int n = 80;
        if (this.fE < 0.6) {
            while (Math.abs((d6 = d5 + this.fE * Math.sin(d3 = d6)) - d3) > 1.0E-12 && --n > 0) {
            }
        } else {
            do {
                d2 = d5 + this.fE * Math.sin(d6) - d6;
                double d7 = 1.0 - this.fE * Math.cos(d6);
                if (Math.abs(d2) < 1.0E-12 || Math.abs(d7) < 1.0E-12) break;
                d3 = d2 / d7;
                d6 += d3;
            } while (Math.abs(d3) > 1.0E-12 && --n > 0);
        }
        if (n == 0) {
            throw new ArithmeticException();
        }
        d3 = d4 * (Math.cos(d6) - this.fE);
        d2 = d4 * Math.sqrt(1.0 - this.fE * this.fE) * Math.sin(d6);
        return new Xyz(d3, d2, 0.0);
    }

    private Xyz CometStatusPara(double d) {
        double d2;
        double d3;
        double d4;
        if (this.fQ == 0.0) {
            throw new ArithmeticException();
        }
        double d5 = d4 = 0.01720209895 * (d - this.fT) / (Math.sqrt(2.0) * this.fQ * Math.sqrt(this.fQ));
        int n = 80;
        while (Math.abs((d5 = ((d3 = d5 * d5) * d5 * 2.0 / 3.0 + d4) / (1.0 + d3)) - (d2 = d5)) > 1.0E-12 && --n > 0) {
        }
        if (n == 0) {
            throw new ArithmeticException();
        }
        d3 = d5 * d5;
        double d6 = this.fQ * (1.0 - d3);
        double d7 = 2.0 * this.fQ * d5;
        return new Xyz(d6, d7, 0.0);
    }

    private Xyz CometStatusNearPara(double d) {
        double d2;
        if (this.fQ == 0.0) {
            throw new ArithmeticException();
        }
        double d3 = Math.sqrt((1.0 + 9.0 * this.fE) / 10.0);
        double d4 = 5.0 * (1.0 - this.fE) / (1.0 + 9.0 * this.fE);
        double d5 = 1.0;
        double d6 = 1.0;
        double d7 = 1.0;
        int n = 80;
        do {
            double d8;
            double d9;
            d2 = d7;
            double d10 = d6;
            double d11 = d10 * d3 * 0.01720209895 * (d - this.fT) / (Math.sqrt(2.0) * this.fQ * Math.sqrt(this.fQ));
            int n2 = 80;
            while (Math.abs((d5 = ((d9 = (d8 = d5) * d8) * d8 * 2.0 / 3.0 + d11) / (1.0 + d9)) - d8) > 1.0E-12 && --n2 > 0) {
            }
            if (n2 == 0) {
                throw new ArithmeticException();
            }
            d7 = d4 * d5 * d5;
            d6 = (-0.003809524 * d7 - 0.017142857) * d7 * d7 + 1.0;
        } while (Math.abs(d7 - d2) > 1.0E-12 && --n > 0);
        if (n == 0) {
            throw new ArithmeticException();
        }
        double d12 = ((0.12495238 * d7 + 0.21714286) * d7 + 0.4) * d7 + 1.0;
        double d13 = ((0.00571429 * d7 + 0.2) * d7 - 1.0) * d7 + 1.0;
        double d14 = Math.sqrt(5.0 * (1.0 + this.fE) / (1.0 + 9.0 * this.fE)) * d12 * d5;
        double d15 = this.fQ * d13 * (1.0 - d14 * d14);
        double d16 = 2.0 * this.fQ * d13 * d14;
        return new Xyz(d15, d16, 0.0);
    }

    public Xyz GetPos(double d) {
        Xyz xyz = this.fE < 0.98 ? this.CometStatusEllip(d) : (Math.abs(this.fE - 1.0) < 1.0E-12 ? this.CometStatusPara(d) : this.CometStatusNearPara(d));
        xyz = xyz.Rotate(this.mtxVC);
        Matrix matrix = Matrix.PrecMatrix(this.atimeEquinox.getJd(), 2451545.0);
        return xyz.Rotate(matrix);
    }

    public String getName() {
        return this.strName;
    }

    public double getT() {
        return this.fT;
    }

    public double getE() {
        return this.fE;
    }

    public double getQ() {
        return this.fQ;
    }

    public double getPeri() {
        return this.fPeri;
    }

    public double getNode() {
        return this.fNode;
    }

    public double getIncl() {
        return this.fIncl;
    }

    public double getEquinox() {
        return this.fEquinox;
    }

    public double getEquinoxJd() {
        return this.atimeEquinox.getJd();
    }

    public Matrix getVectorConstant() {
        return this.mtxVC;
    }
}

