/*
 * Decompiled with CFR 0.152.
 */
import astro.ATime;
import astro.Comet;
import astro.TimeSpan;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.io.Serializable;
import java.util.Date;

public class OrbitViewer
extends Applet {
    private Scrollbar scrollHorz;
    private Scrollbar scrollVert;
    private Scrollbar scrollZoom;
    private OrbitCanvas orbitCanvas;
    private Button buttonDate;
    private Button buttonRevPlay;
    private Button buttonRevStep;
    private Button buttonStop;
    private Button buttonForStep;
    private Button buttonForPlay;
    private Choice choiceTimeStep;
    private Choice choiceCenterObject;
    private Choice choiceOrbitObject;
    private Checkbox checkPlanetName;
    private Checkbox checkObjectName;
    private Checkbox checkDistanceLabel;
    private Checkbox checkDateLabel;
    private DateDialog dateDialog;
    private OrbitPlayer orbitPlayer;
    Thread playerThread;
    private ATime atime;
    static final int timeStepCount = 8;
    static final String[] timeStepLabel = new String[]{"1 Hour", "1 Day", "3 Days", "10 Days", "1 Month", "3 Months", "6 Months", "1 Year"};
    static final TimeSpan[] timeStepSpan = new TimeSpan[]{new TimeSpan(0, 0, 0, 1, 0, 0.0), new TimeSpan(0, 0, 1, 0, 0, 0.0), new TimeSpan(0, 0, 3, 0, 0, 0.0), new TimeSpan(0, 0, 10, 0, 0, 0.0), new TimeSpan(0, 1, 0, 0, 0, 0.0), new TimeSpan(0, 3, 0, 0, 0, 0.0), new TimeSpan(0, 6, 0, 0, 0, 0.0), new TimeSpan(1, 0, 0, 0, 0, 0.0)};
    public TimeSpan timeStep = timeStepSpan[1];
    public int playDirection = 1;
    static final int CenterObjectCount = 11;
    static final String[] CenterObjectLabel = new String[]{"Sun", "Asteroid/Comet", "Mercury", "Venus", "Earth", "Mars", "Jupiter", "Saturn", "Uranus", "Neptune", "Pluto"};
    public int CenterObjectSelected;
    static final int OrbitDisplayCount = 14;
    static final String[] OrbitDisplayLabel = new String[]{"Default Orbits", "All Orbits", "No Orbits", "------", "Asteroid/Comet", "Mercury", "Venus", "Earth", "Mars", "Jupiter", "Saturn", "Uranus", "Neptune", "Pluto"};
    public int OrbitCount = 11;
    public boolean[] OrbitDisplay;
    public boolean[] OrbitDisplayDefault;
    private ATime minATime;
    private ATime maxATime;
    static final int initialScrollVert = 130;
    static final int initialScrollHorz = 255;
    static final int initialScrollZoom = 67;
    static final int fontSize = 16;

    public String getAppletInfo() {
        return "OrbitViewer v1.3 Copyright(C) 1996-2001 by O.Ajiki/R.Baalke";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Name", "String", "Name of the object          ex. 1P/Halley"}, {"T", "double", "Time of perihelion passage  ex. 19860209.7695"}, {"e", "double", "Eccentricity                ex. 0.967267"}, {"q", "double", "Perihelion distance AU      ex. 0.587096"}, {"Peri", "double", "Argument of perihelion deg. ex. 111.8466"}, {"Node", "double", "Ascending node deg.         ex.  58.1440"}, {"Incl", "double", "Inclination deg.            ex. 162.2393"}, {"Eqnx", "double", "Year of equinox             ex. 1950.0"}, {"Epoch", "double", "Year/Month/Day of epoch     ex. 19991118.5"}, {"M", "double", "Mean anomaly deg.           ex. 356.648434"}, {"a", "double", "Semimajor axis AU           ex. 2.76631592"}, {"Date", "double", "Initial date                ex. 19860209.7695"}};
        return stringArray;
    }

    private ATime ymdStringToAtime(String string) {
        double d = Double.valueOf(string);
        int n = (int)Math.floor(d / 10000.0);
        int n2 = (int)Math.floor((d -= (double)n * 10000.0) / 100.0);
        double d2 = d - (double)n2 * 100.0;
        return new ATime(n, n2, d2, 0.0);
    }

    private double getRequiredParameter(String string) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            throw new Error("Required parameter '" + string + "' not found.");
        }
        return Double.valueOf(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Comet getObject() {
        double d;
        ATime aTime;
        String string;
        String string2 = this.getParameter("Name");
        if (string2 == null) {
            string2 = "Object";
        }
        if ((string = this.getParameter("e")) == null) {
            throw new Error("required parameter 'e' not found.");
        }
        double d2 = Double.valueOf(string);
        string = this.getParameter("T");
        if (string != null) {
            aTime = this.ymdStringToAtime(string);
            string = this.getParameter("q");
            if (string != null) {
                d = Double.valueOf(string);
                return new Comet(string2, aTime.getJd(), d2, d, this.getRequiredParameter("Peri") * Math.PI / 180.0, this.getRequiredParameter("Node") * Math.PI / 180.0, this.getRequiredParameter("Incl") * Math.PI / 180.0, this.getRequiredParameter("Eqnx"));
            } else {
                string = this.getParameter("a");
                if (string == null) throw new Error("Required parameter 'q' or 'a' not found.");
                double d3 = Double.valueOf(string);
                if (Math.abs(d2 - 1.0) < 1.0E-15) {
                    throw new Error("Orbit is parabolic, but 'q' not found.");
                }
                d = d3 * (1.0 - d2);
            }
            return new Comet(string2, aTime.getJd(), d2, d, this.getRequiredParameter("Peri") * Math.PI / 180.0, this.getRequiredParameter("Node") * Math.PI / 180.0, this.getRequiredParameter("Incl") * Math.PI / 180.0, this.getRequiredParameter("Eqnx"));
        } else {
            double d4;
            string = this.getParameter("Epoch");
            if (string == null) throw new Error("Required parameter 'T' or 'Epoch' not found.");
            ATime aTime2 = this.ymdStringToAtime(string);
            if (d2 > 0.95) {
                throw new Error("Orbit is nearly parabolic, but 'T' not found.");
            }
            string = this.getParameter("a");
            if (string != null) {
                d4 = Double.valueOf(string);
                d = d4 * (1.0 - d2);
            } else {
                string = this.getParameter("q");
                if (string == null) throw new Error("Required parameter 'q' or 'a' not found.");
                d = Double.valueOf(string);
                d4 = d / (1.0 - d2);
            }
            if (d < 1.0E-15) {
                throw new Error("Too small perihelion distance.");
            }
            double d5 = 0.01720209895 / (d4 * Math.sqrt(d4));
            string = this.getParameter("M");
            if (string == null) {
                throw new Error("Required parameter 'M' not found.");
            }
            double d6 = Double.valueOf(string) * Math.PI / 180.0;
            aTime = d6 < Math.PI ? new ATime(aTime2.getJd() - d6 / d5, 0.0) : new ATime(aTime2.getJd() + (Math.PI * 2 - d6) / d5, 0.0);
        }
        return new Comet(string2, aTime.getJd(), d2, d, this.getRequiredParameter("Peri") * Math.PI / 180.0, this.getRequiredParameter("Node") * Math.PI / 180.0, this.getRequiredParameter("Incl") * Math.PI / 180.0, this.getRequiredParameter("Eqnx"));
    }

    private ATime limitATime(ATime aTime) {
        if (aTime.getJd() <= this.minATime.getJd()) {
            return new ATime(this.minATime);
        }
        if (this.maxATime.getJd() <= aTime.getJd()) {
            return new ATime(this.maxATime);
        }
        return aTime;
    }

    private void setNewDate() {
        this.atime = this.limitATime(this.atime);
        this.orbitCanvas.setDate(this.atime);
        this.orbitCanvas.repaint();
    }

    public ATime getAtime() {
        return this.atime;
    }

    public void setNewDate(ATime aTime) {
        this.atime = this.limitATime(aTime);
        this.orbitCanvas.setDate(this.atime);
        this.orbitCanvas.repaint();
    }

    public void init() {
        Serializable serializable;
        this.setBackground(Color.white);
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        panel.setLayout(gridBagLayout);
        Comet comet = this.getObject();
        String string = this.getParameter("Date");
        if (string != null) {
            this.atime = this.ymdStringToAtime(string);
        } else {
            serializable = new Date();
            this.atime = new ATime(serializable.getYear() + 1900, serializable.getMonth() + 1, serializable.getDate(), 0.0);
        }
        this.orbitCanvas = new OrbitCanvas(comet, this.atime);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.orbitCanvas, gridBagConstraints);
        panel.add(this.orbitCanvas);
        this.scrollVert = new Scrollbar(1, 130, 12, 0, 192);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.scrollVert, gridBagConstraints);
        panel.add(this.scrollVert);
        this.orbitCanvas.setRotateVert(180 - this.scrollVert.getValue());
        this.scrollHorz = new Scrollbar(0, 255, 15, 0, 375);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.scrollHorz, gridBagConstraints);
        panel.add(this.scrollHorz);
        this.orbitCanvas.setRotateHorz(270 - this.scrollHorz.getValue());
        serializable = new Panel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints((Component)serializable, gridBagConstraints);
        panel.add((Component)serializable);
        Panel panel2 = new Panel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        panel2.setLayout(gridBagLayout2);
        panel2.setBackground(Color.white);
        this.buttonDate = new Button(" Date ");
        this.buttonDate.setFont(new Font("Dialog", 0, 16));
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 12);
        gridBagLayout2.setConstraints(this.buttonDate, gridBagConstraints2);
        panel2.add(this.buttonDate);
        this.buttonRevPlay = new Button("<<");
        this.buttonRevPlay.setFont(new Font("Dialog", 1, 14));
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 3, 0);
        gridBagLayout2.setConstraints(this.buttonRevPlay, gridBagConstraints2);
        panel2.add(this.buttonRevPlay);
        this.buttonRevStep = new Button("|<");
        this.buttonRevStep.setFont(new Font("Dialog", 1, 14));
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 3, 0);
        gridBagLayout2.setConstraints(this.buttonRevStep, gridBagConstraints2);
        panel2.add(this.buttonRevStep);
        this.buttonStop = new Button("||");
        this.buttonStop.setFont(new Font("Dialog", 1, 14));
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 3, 0);
        gridBagLayout2.setConstraints(this.buttonStop, gridBagConstraints2);
        panel2.add(this.buttonStop);
        this.buttonForStep = new Button(">|");
        this.buttonForStep.setFont(new Font("Dialog", 1, 14));
        gridBagConstraints2.gridx = 4;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 3, 0);
        gridBagLayout2.setConstraints(this.buttonForStep, gridBagConstraints2);
        panel2.add(this.buttonForStep);
        this.buttonForPlay = new Button(">>");
        this.buttonForPlay.setFont(new Font("Dialog", 1, 14));
        gridBagConstraints2.gridx = 5;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 3, 0);
        gridBagLayout2.setConstraints(this.buttonForPlay, gridBagConstraints2);
        panel2.add(this.buttonForPlay);
        this.choiceTimeStep = new Choice();
        this.choiceTimeStep.setFont(new Font("Dialog", 0, 16));
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 5;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagLayout2.setConstraints(this.choiceTimeStep, gridBagConstraints2);
        panel2.add(this.choiceTimeStep);
        int n = 0;
        while (n < 8) {
            this.choiceTimeStep.addItem(timeStepLabel[n]);
            this.choiceTimeStep.select(timeStepLabel[1]);
            ++n;
        }
        Label label = new Label("Center:");
        label.setAlignment(0);
        label.setFont(new Font("Dialog", 0, 16));
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagLayout2.setConstraints(label, gridBagConstraints2);
        panel2.add(label);
        this.choiceCenterObject = new Choice();
        this.choiceCenterObject.setFont(new Font("Dialog", 0, 16));
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 5;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagLayout2.setConstraints(this.choiceCenterObject, gridBagConstraints2);
        panel2.add(this.choiceCenterObject);
        int n2 = 0;
        while (n2 < 11) {
            this.choiceCenterObject.addItem(CenterObjectLabel[n2]);
            ++n2;
        }
        this.orbitCanvas.SelectCenterObject(0);
        Label label2 = new Label("Orbits:");
        label2.setAlignment(0);
        label2.setFont(new Font("Dialog", 0, 16));
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagLayout2.setConstraints(label2, gridBagConstraints2);
        panel2.add(label2);
        this.choiceOrbitObject = new Choice();
        this.choiceOrbitObject.setFont(new Font("Dialog", 0, 16));
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 5;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagLayout2.setConstraints(this.choiceOrbitObject, gridBagConstraints2);
        panel2.add(this.choiceOrbitObject);
        int n3 = 0;
        while (n3 < 14) {
            this.choiceOrbitObject.addItem(OrbitDisplayLabel[n3]);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.OrbitCount) {
            this.OrbitDisplay[n4] = this.OrbitDisplayDefault[n4];
            ++n4;
        }
        this.orbitCanvas.SelectOrbits(this.OrbitDisplay, this.OrbitCount);
        this.checkDateLabel = new Checkbox("Date Label");
        this.checkDateLabel.setState(true);
        this.checkDateLabel.setFont(new Font("Dialog", 0, 16));
        gridBagConstraints2.gridx = 6;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 12, 0, 0);
        gridBagLayout2.setConstraints(this.checkDateLabel, gridBagConstraints2);
        panel2.add(this.checkDateLabel);
        this.orbitCanvas.switchPlanetName(this.checkDateLabel.getState());
        this.checkPlanetName = new Checkbox("Planet Labels");
        this.checkPlanetName.setState(true);
        this.checkPlanetName.setFont(new Font("Dialog", 0, 16));
        gridBagConstraints2.gridx = 7;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 12, 0, 0);
        gridBagLayout2.setConstraints(this.checkPlanetName, gridBagConstraints2);
        panel2.add(this.checkPlanetName);
        this.orbitCanvas.switchPlanetName(this.checkPlanetName.getState());
        this.checkDistanceLabel = new Checkbox("Distance");
        this.checkDistanceLabel.setState(true);
        this.checkDistanceLabel.setFont(new Font("Dialog", 0, 16));
        gridBagConstraints2.gridx = 6;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 12, 0, 0);
        gridBagLayout2.setConstraints(this.checkDistanceLabel, gridBagConstraints2);
        panel2.add(this.checkDistanceLabel);
        this.orbitCanvas.switchPlanetName(this.checkDistanceLabel.getState());
        this.checkObjectName = new Checkbox("Object Label");
        this.checkObjectName.setState(true);
        this.checkObjectName.setFont(new Font("Dialog", 0, 16));
        gridBagConstraints2.gridx = 7;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 12, 0, 0);
        gridBagLayout2.setConstraints(this.checkObjectName, gridBagConstraints2);
        panel2.add(this.checkObjectName);
        this.orbitCanvas.switchObjectName(this.checkObjectName.getState());
        Label label3 = new Label("Zoom:");
        label3.setAlignment(0);
        label3.setFont(new Font("Dialog", 0, 16));
        gridBagConstraints2.gridx = 6;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(10, 12, 0, 0);
        gridBagLayout2.setConstraints(label3, gridBagConstraints2);
        panel2.add(label3);
        this.scrollZoom = new Scrollbar(0, 67, 15, 5, 450);
        gridBagConstraints2.gridx = 6;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(0, 12, 6, 2);
        gridBagLayout2.setConstraints(this.scrollZoom, gridBagConstraints2);
        panel2.add(this.scrollZoom);
        this.orbitCanvas.setZoom(this.scrollZoom.getValue());
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        this.setLayout(gridBagLayout3);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.gridwidth = 0;
        gridBagLayout3.setConstraints(panel, gridBagConstraints3);
        this.add(panel);
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 0.0;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.gridheight = 0;
        gridBagConstraints3.insets = new Insets(6, 0, 0, 0);
        gridBagLayout3.setConstraints(panel2, gridBagConstraints3);
        this.add(panel2);
        this.orbitPlayer = new OrbitPlayer(this);
        this.playerThread = null;
    }

    public void start() {
    }

    public void stop() {
        if (this.dateDialog != null) {
            this.dateDialog.dispose();
            this.endDateDialog(null);
        }
        if (this.playerThread != null) {
            this.playerThread.stop();
            this.playerThread = null;
            this.buttonDate.enable();
        }
    }

    public void destroy() {
        this.removeAll();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                if (event.target == this.scrollHorz) {
                    this.orbitCanvas.setRotateHorz(270 - this.scrollHorz.getValue());
                } else if (event.target == this.scrollVert) {
                    this.orbitCanvas.setRotateVert(180 - this.scrollVert.getValue());
                } else {
                    if (event.target != this.scrollZoom) return false;
                    this.orbitCanvas.setZoom(this.scrollZoom.getValue());
                }
                this.orbitCanvas.repaint();
                return true;
            }
            case 1001: {
                if (event.target == this.buttonDate) {
                    this.dateDialog = new DateDialog(this, this.atime);
                    this.buttonDate.disable();
                    return true;
                }
                if (event.target == this.buttonForPlay) {
                    if (this.playerThread != null && this.playDirection != 1) {
                        this.playerThread.stop();
                        this.playerThread = null;
                    }
                    if (this.playerThread != null) return false;
                    this.buttonDate.disable();
                    this.playDirection = 1;
                    this.playerThread = new Thread(this.orbitPlayer);
                    this.playerThread.setPriority(1);
                    this.playerThread.start();
                    return false;
                }
                if (event.target == this.buttonRevPlay) {
                    if (this.playerThread != null && this.playDirection != -1) {
                        this.playerThread.stop();
                        this.playerThread = null;
                    }
                    if (this.playerThread != null) return false;
                    this.buttonDate.disable();
                    this.playDirection = -1;
                    this.playerThread = new Thread(this.orbitPlayer);
                    this.playerThread.setPriority(1);
                    this.playerThread.start();
                    return false;
                }
                if (event.target == this.buttonStop) {
                    if (this.playerThread == null) return false;
                    this.playerThread.stop();
                    this.playerThread = null;
                    this.buttonDate.enable();
                    return false;
                }
                if (event.target == this.buttonForStep) {
                    this.atime.changeDate(this.timeStep, 1);
                    this.setNewDate();
                    return true;
                }
                if (event.target == this.buttonRevStep) {
                    this.atime.changeDate(this.timeStep, -1);
                    this.setNewDate();
                    return true;
                }
                if (event.target == this.checkPlanetName) {
                    this.orbitCanvas.switchPlanetName(this.checkPlanetName.getState());
                    this.orbitCanvas.repaint();
                    return true;
                }
                if (event.target == this.checkObjectName) {
                    this.orbitCanvas.switchObjectName(this.checkObjectName.getState());
                    this.orbitCanvas.repaint();
                    return true;
                }
                if (event.target == this.checkDistanceLabel) {
                    this.orbitCanvas.switchDistanceLabel(this.checkDistanceLabel.getState());
                    this.orbitCanvas.repaint();
                    return true;
                }
                if (event.target == this.checkDateLabel) {
                    this.orbitCanvas.switchDateLabel(this.checkDateLabel.getState());
                    this.orbitCanvas.repaint();
                    return true;
                }
                if (event.target == this.choiceTimeStep) {
                    int n = 0;
                    while (n < 8) {
                        if ((String)event.arg == timeStepLabel[n]) {
                            this.timeStep = timeStepSpan[n];
                            return false;
                        }
                        ++n;
                    }
                    return false;
                }
                if (event.target == this.choiceCenterObject) {
                    int n = 0;
                    while (n < 11) {
                        if ((String)event.arg == CenterObjectLabel[n]) {
                            this.CenterObjectSelected = n;
                            this.orbitCanvas.SelectCenterObject(n);
                            this.orbitCanvas.repaint();
                            return false;
                        }
                        ++n;
                    }
                    return false;
                }
                if (event.target != this.choiceOrbitObject) return false;
                int n = 0;
                while (n < 14) {
                    if ((String)event.arg == OrbitDisplayLabel[n]) {
                        if (n == 1) {
                            int n2 = 0;
                            while (n2 < this.OrbitCount) {
                                this.OrbitDisplay[n2] = true;
                                ++n2;
                            }
                        } else if (n == 2) {
                            int n3 = 0;
                            while (n3 < this.OrbitCount) {
                                this.OrbitDisplay[n3] = false;
                                ++n3;
                            }
                        } else if (n == 0) {
                            int n4 = 0;
                            while (n4 < this.OrbitCount) {
                                this.OrbitDisplay[n4] = this.OrbitDisplayDefault[n4];
                                ++n4;
                            }
                        } else if (n > 3) {
                            this.OrbitDisplay[n - 3] = !this.OrbitDisplay[n - 3];
                        }
                        event.arg = OrbitDisplayLabel[0];
                        this.orbitCanvas.SelectOrbits(this.OrbitDisplay, this.OrbitCount);
                        this.orbitCanvas.repaint();
                        return false;
                    }
                    ++n;
                }
                return false;
            }
        }
        return false;
    }

    public void endDateDialog(ATime aTime) {
        this.dateDialog = null;
        this.buttonDate.enable();
        if (aTime != null) {
            this.atime = this.limitATime(aTime);
            this.orbitCanvas.setDate(aTime);
            this.orbitCanvas.repaint();
        }
    }

    public OrbitViewer() {
        boolean[] blArray = new boolean[11];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        this.OrbitDisplay = blArray;
        boolean[] blArray2 = new boolean[11];
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[3] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        blArray2[6] = true;
        this.OrbitDisplayDefault = blArray2;
        this.minATime = new ATime(1600, 1, 1, 0, 0, 0.0, 0.0);
        this.maxATime = new ATime(2200, 1, 1, 0, 0, 0.0, 0.0);
    }
}

